/*  -*-objc-*-
 *  ToolsPanel.m: Implementation of the ToolsPanel Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "ToolsPanel.h"
#include "AppsView.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation ToolsPanel

- (void)dealloc
{
	TEST_RELEASE (fileIcon);
	RELEASE (multipleIcon);
	RELEASE (namefield);
	RELEASE (pathfield);
	RELEASE (revertbutt);
	RELEASE (okbutt);		
	RELEASE (appsView);
	RELEASE (noToolsLabel);
  [super dealloc];
}

- (id)init
{
	id label;  
		
	self = [super init];
	if(self) {
    [self setFrame: NSMakeRect(0, 0, 274, 385)];	
			
		ASSIGN (multipleIcon, [NSImage imageNamed: @"MultipleSelection.tiff"]);

		ws = [NSWorkspace sharedWorkspace];

    appsView = nil;

		MAKE_LABEL (namefield, NSMakeRect(66, 343, 200, 25), nil, 'l', NO, self);		  
		[namefield setFont: [NSFont systemFontOfSize: 18]];
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(9, 301, 40, 20), @"Path:", @"", 'l', YES, self);		  
		MAKE_LABEL (pathfield, NSMakeRect(44, 301, 215, 20), nil, 'l', NO, self);		  
		MAKE_LOCALIZED_LABEL (noToolsLabel, NSMakeRect(10, 173, 254, 25), @"No Tools Inspector", @"", 'c', NO, self);		  
    [noToolsLabel setFont: [NSFont systemFontOfSize: 18]];
    [noToolsLabel setTextColor: [NSColor grayColor]];	
		
		revertbutt = [[NSButton alloc] initWithFrame: NSMakeRect(17, 10, 115, 24)];
		[revertbutt setButtonType: NSMomentaryLight];
		[revertbutt setTitle: NSLocalizedString(@"Revert", @"")];
		[self addSubview: revertbutt]; 

		okbutt = [[NSButton alloc] initWithFrame: NSMakeRect(140, 10, 115, 24)];
		[okbutt setButtonType: NSMomentaryLight];
		[okbutt setTitle: NSLocalizedString(@"Set Default", @"")];	
		[okbutt setKeyEquivalent: @"\r"];
		[okbutt setImagePosition: NSImageRight];
		[okbutt setImage: [NSImage imageNamed: @"common_ret"]];		
		[self addSubview: okbutt]; 

    appsView = [[AppsView alloc] initInPanel: self 
																	 withFrame: NSMakeRect(8, 40, 257, 245)];		
		valid = NO;
	}
	return self;
}

- (void)activateForPaths:(NSArray *)paths
{
	int pathscount;
  NSString *currentPath;  
 	NSString *s;
  BOOL toolsok;
	int i;

	[okbutt setEnabled: NO];		
	[revertbutt setEnabled: NO];

	pathscount = [paths count];
  currentPath = [paths objectAtIndex: 0];

	if (pathscount == 1) {    
		ASSIGN (fileIcon, [ws iconForFile: currentPath]);
		[namefield setStringValue: [currentPath lastPathComponent]];
		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];  
  } else {
		ASSIGN (fileIcon, multipleIcon);		
		[namefield setStringValue: [NSString stringWithFormat: @"%i items", pathscount]];
		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];
  }

  toolsok = YES; 
  for (i = 0; i < [paths count]; i++) {
		NSString *defApp = nil;
		NSString *fType = nil;

	  currentPath = [paths objectAtIndex: i];
		[ws getInfoForFile: currentPath application: &defApp type: &fType];		
		if ([fType isEqualToString: NSPlainFileType] == NO) {
			toolsok = NO;		
			break;
    }
  }
    
	if (toolsok == YES) {		  	
		if (valid == NO) {
			[noToolsLabel removeFromSuperview];
			[self addSubview: appsView];
			valid = YES;
		}
		[appsView setPaths: paths];
		
	} else {
		if (valid == YES) {
			[appsView removeFromSuperview];
			[self addSubview: noToolsLabel];
			valid = NO;
		}
	}
	
	[self setNeedsDisplay: YES];	
}

- (void)deactivate
{
	[self removeFromSuperview];
}

- (NSString *)inspname
{
	return NSLocalizedString(@"Tools", @"");
}

- (NSString *)winname
{
	return NSLocalizedString(@"Tools Inspector", @"");
}

- (NSButton *)revertButton
{
	return revertbutt;
}

- (NSButton *)okButton
{
	return okbutt;
}

- (void)drawRect:(NSRect)rect
{
	STROKE_LINE (darkGrayColor, 0, 385, 274, 385);
	STROKE_LINE (whiteColor, 0, 384, 274, 384);

	if(fileIcon != nil) {
		[fileIcon compositeToPoint: NSMakePoint(8, 325) operation: NSCompositeSourceOver];
	}

	STROKE_LINE (darkGrayColor, 0, 294, 274, 294);
	STROKE_LINE (whiteColor, 0, 293, 274, 293);
}

@end
