/*  -*-objc-*-
 *  GenericContsView.m: Implementation of the GenericContsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "GenericContsView.h"
#include "Functions.h"

@implementation GenericContsView

- (void)dealloc
{
  [nc removeObserver: self];
  if (task && [task isRunning]) {
    [task terminate];
	}
  TEST_RELEASE (task);
	[super dealloc];
}

- (id)initWithFrame:(NSRect)frameRect
{
	self = [super initWithFrame: frameRect];
	
	if (self) {	
		[self setRichText: NO];
		[self setDrawsBackground: NO];
		myStorage = [self textStorage];
		nc = [NSNotificationCenter defaultCenter];
	}
	
	return self;
}

- (void)findContentsAtPath:(NSString *)apath
{
  NSArray *args;
	NSFileHandle *fileHandle;

  if (task && [task isRunning]) {
		[task terminate];
		DESTROY (task);		
	}

	ASSIGN (task, [NSTask new]); 
  [task setLaunchPath: @"/bin/sh"];

  args = [NSArray arrayWithObjects: @"-c", [NSString stringWithFormat: @"file -b %@", apath], nil];
  [task setArguments: args];

  ASSIGN (pipe, [NSPipe pipe]);
	AUTORELEASE (pipe);
  [task setStandardOutput: pipe];
    
  fileHandle = [pipe fileHandleForReading];
  [nc addObserver: self
    		 selector: @selector(dataFromTask:)
    				 name: NSFileHandleReadToEndOfFileCompletionNotification
    			 object: (id)fileHandle];

  [fileHandle readToEndOfFileInBackgroundAndNotify];    
  
  [nc addObserver: self 
         selector: @selector(endOfTask:) 
             name: NSTaskDidTerminateNotification 
           object: (id)task];
                     
  [task launch];            
}

- (void)dataFromTask:(NSNotification *)notification
{
  NSDictionary *userInfo = [notification userInfo];
  NSData *readData = [userInfo objectForKey: NSFileHandleNotificationDataItem];
  NSString *descrstr = [[NSString alloc] initWithData: readData encoding: NSNonLossyASCIIStringEncoding];
  NSRange range;
	
	[self setSelectable: YES];

	if (([self string]) && ([[self string] length])) {
		[self replaceCharactersInRange: NSMakeRange(0, [[self string] length])
												withString: descrstr];
	} else {
		[self insertText: descrstr];
	}
  RELEASE (descrstr);
	
	range = NSMakeRange(0, [[self string] length]);
	
	[self setAlignment: NSCenterTextAlignment 
							 range: range];
	
	[myStorage addAttribute: NSFontAttributeName 
										value: [NSFont systemFontOfSize: 18] 
										range: range];
		
	[myStorage addAttribute: NSForegroundColorAttributeName 
										value: [NSColor grayColor] 
										range: range];			

	[self setSelectable: NO];	
	[self setNeedsDisplay: YES];								
}

- (void)endOfTask:(NSNotification *)notification
{
	if ([notification object] == task) {		
		[nc removeObserver: self name: NSTaskDidTerminateNotification object: task];
		DESTROY (task);										
	}
}

@end
