// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Acquisition dialog
// ****************************************************************************

// Copyright 2008, 2009, 2010, 2011 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DLGACQUIRE_H__
#define __DLGACQUIRE_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

#ifndef __DEVICE_H__
  #include "device.h"
#endif

#ifndef __CONFIG_H__
   class   t_CfgEntryMode;
   class   t_CfgDlgAcquireField;
   typedef t_CfgDlgAcquireField *t_pCfgDlgAcquireField;
#endif

class t_DlgAcquireLineEdit;
class t_DlgAcquireLocal;

class t_DlgAcquire: public QDialog
{
   Q_OBJECT

   public:
      t_DlgAcquire ();
      t_DlgAcquire (t_pDevice pDevice, bool Clone, t_pDeviceList pDeviceList, QWidget *pParent=NULL, Qt::WFlags Flags=0);
     ~t_DlgAcquire ();

      APIRET GetParameters (t_Device::t_Acquisition &Acquisition, bool RememberLastUsedValues=true);
   private:
      t_CfgEntryMode EntryMode            (t_pCfgDlgAcquireField pField);
      APIRET         AddField             (t_pDevice pDevice, t_pCfgDlgAcquireField pField, QGridLayout *pLayout, int *pRow, int *pCol);
      APIRET         CheckWriteAccess     (const QString &Path, const QString &Filename, bool &Ok);
      APIRET         CreateDeviceTable    (t_pDeviceList pDeviceList, t_pDevice pDeviceSrc, QTableWidget **ppTable);
      APIRET         InsertDeviceTableRow (QTableWidget *pTable, int Row, t_pDeviceList pDeviceList, t_pDevice pDevSrc, t_pDevice pDev);

   private slots:
      void UpdateHashState     (int State=0);
      void UpdateDialogState   (const QString & NewText = QString());
      void UpdateFieldState    (void);
      void UpdateFileSplitState(void);
      void SlotBrowse          (void);
      void SlotAccept          (void);
      void SlotTextEdited      (t_DlgAcquireLineEdit *pLineEdit, const QString &NewVal);
      void SlotDeviceTableSelectionChanged (void);

   private:
      t_DlgAcquireLocal *pOwn;
};

enum
{
   ERROR_DLGACQUIRE_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_DLGACQUIRE + 1,
   ERROR_DLGACQUIRE_UNKNOWN_FILEDIALOG_SIZE,
   ERROR_DLGACQUIRE_INVALID_ENTRYMODE,
   ERROR_DLGACQUIRE_INVALID_FORMAT,
   ERROR_DLGACQUIRE_INVALID_SELECTION,
};

#endif

