/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include <gtrans_ifase/gtrans_ifase.h>
#include "gtrans_db_editor.h"
#include "gtrans_error_dialog.h"
#include "gtrans_table_designer.h"




/**
 * gtrans_create_table_commit:
 * @gtd  : The Table Designer
 *
 * Commit the Table Design to the databse server.
 */
static void
gtrans_create_table_commit(GTransTableDesigner *gtd)
{
	GList *list;
	gchar *errmsg, *name;
	
	name = gtrans_table_designer_get_table_name(gtd);
	list = gtrans_table_designer_get_table_def(gtd);
	errmsg = gtrans_ifase_table_designer_create_table(gtd->conn,name,list);

	if (errmsg){
		gtrans_error_dialog(errmsg);
		return;
	}
	
	/* Refresh the table, cause we did some changes in the server */
	gtk_signal_emit_by_name(GTK_OBJECT(gtd->owner),"refresh");
	
	gtrans_db_editor_remove_child(GTRANS_DB_EDITOR(gtd->owner),GTK_WIDGET(gtd));
	gtk_widget_destroy(GTK_WIDGET(gtd));
}






/**
 * gtrans_create_table_close:
 * 
 */
static void
gtrans_create_table_close(GTransTableDesigner *gtd)
{
	gtrans_db_editor_remove_child(GTRANS_DB_EDITOR(gtd->owner),GTK_WIDGET(gtd));
	gtk_widget_destroy(GTK_WIDGET(gtd));
}





/**
 * gtrans_create_table
 * @gde  : The Database Editor
 *
 * Start the table designer.
 */
void
gtrans_create_table(GTransDbEditor  *gde)
{
	GtkWidget *gtd;
	
	gtd = gtrans_table_designer_new(gde->conn,GTK_WIDGET(gde));
	gtk_signal_connect_object(GTK_OBJECT(gtd),"ok",
				  GTK_SIGNAL_FUNC(gtrans_create_table_commit),
				  GTK_OBJECT(gtd));
	
	gtk_signal_connect_object(GTK_OBJECT(gtd),"close",
				  GTK_SIGNAL_FUNC(gtrans_create_table_close),
				  GTK_OBJECT(gtd));
	
	/* Set the 'Db Editor' as the paren of the 'Table Designer' */
	gtrans_db_editor_add_child(gde,gtd);

	gtk_widget_show_all(gtd);
}









