/*

This file is part of GShare.

GShare is free software; you can redistribute it 
and/or modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2 of 
the License, or (at your option) any later version.

GShare  is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GShare; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

The Initial Developer of the Original Code is Celso Pinto.
Portions created by Celso Pinto is Copyright (C) 2006. 

All Rights Reserved.

*/

using System;

using DBus;

namespace GShare
{

    /*saw this on Banshee CVS... looks good enough*/
    [Interface("org.freedesktop.DBus")]
    internal abstract class DBusProxy
    {
        [Method] public abstract uint StartServiceByName(string name, uint flag);
        
        public static bool StartServiceByName(string serviceName)
        {
            Service dbusService = Service.Get(Bus.GetSessionBus(),"org.freedesktop.DBus");
            DBusProxy proxy = (DBusProxy)dbusService.GetObject(typeof(DBusProxy), "/org/freedesktop/DBus");
            System.GC.SuppressFinalize(proxy);
            uint res = proxy.StartServiceByName(serviceName, /* flags, ignored by D-BUS */ 0); 
            return (res == 1);/*1 == TRUE*/
        }
    }
    
    [Interface ("com.yimports.gshare.Service")]
    public class GShareService
    {
        private const string
            BUS_NAME = "com.yimports.gshare",
            DBUS_OBJ_PATH = "/com/yimports/gshare/Service";
        
        private static GShareService self = null;

        private IGShareDaemon iDaemon = null;
        private Connection iConn = null;
        private Service iService = null;
        
        private GShareService()
        {
            iConn = Bus.GetSessionBus();
            iService = new Service(iConn,BUS_NAME);
        }
        
        public static bool ServiceRunning()
        {
            return (Service.HasOwner(Bus.GetSessionBus(),BUS_NAME));
        }
        
        public static GShareService FindDBusInstance()
        {
            Connection conn = Bus.GetSessionBus();
            Service service;
            if (ServiceRunning())
            {
                service = Service.Get(conn,BUS_NAME);
            }
            else
            {

               try
               {
                   
                   if (!DBusProxy.StartServiceByName(BUS_NAME))
                   {
                       /* failed to start service */
                       return null;
                   }
                   
                   service = Service.Get(conn,BUS_NAME);
                    
               }
               catch
               {
                   /* failed to start service */
                   return null;
               }

            }
            
            try
            {
                return (GShareService)service.GetObject(typeof(GShareService),DBUS_OBJ_PATH);
            }
            catch(Exception ex)
            {
                return null;    
            }
        }
        
        public static GShareService GetInstance()
        {
            if (self == null)
                self = new GShareService();
            
            return self;
            
        }

        public void SetDaemon(IGShareDaemon daemon)
        {
            iDaemon = daemon;
        }
        
        public void StartPublishing()
        {
            iService.RegisterObject(this,DBUS_OBJ_PATH);
        }

        public void StopPublishing()
        {
            iService.UnregisterObject(this);
        }

        [Method]
        public virtual void SetAllowAnonymousLogin(bool allowAnonymous)
        {
            iDaemon.AllowAnonymous = allowAnonymous;
        }
        [Method]
        public virtual bool GetAllowAnonymousLogin()
        {
            return iDaemon.AllowAnonymous;
        }

        [Method]
        public virtual void SetLogin(string username,string password)
        {
            iDaemon.Username = username;
            iDaemon.Password = password;
        }

        [Method]
        public virtual string GetUsername()
        {
            return iDaemon.Username;
        }

        [Method]
        public virtual string GetPassword()
        {
            return iDaemon.Password;
        }

        [Method]
        public virtual void SetPermissions(bool allowWrite, bool allowDelete)
        {
            iDaemon.AllowWrite = allowWrite;
            iDaemon.AllowDelete = allowDelete;
        }

        [Method]
        public virtual bool GetAllowWrite()
        {
            return iDaemon.AllowWrite;
        }

        [Method]
        public virtual bool GetAllowDelete()
        {
            return iDaemon.AllowDelete;
        }

        [Method]
        public virtual void SetSharingEnabled(bool enabled)
        {
            iDaemon.SharingEnabled = enabled;
        }

        [Method]
        public virtual bool GetSharingEnabled()
        {
            return iDaemon.SharingEnabled;
        }

        [Method]
        public virtual void Shutdown()
        {
            iDaemon.Shutdown();
        }
        
        [Method]
        public virtual bool IsFirstTime()
        {
            return iDaemon.IsFirstTime;
        }
    }
        
}
