/**************************************************************************/
/*                                                                        */
/*  grubcfg - module to parse the client configuration file               */
/*  Uses parsecfg library written by Yuuki Ninomiya <gm@debian.org.jp>    */
/*  Based on simple.c code written by Yuuki Ninomiya <gm@debian.org.jp>   */
/*                                                                        */
/*  Copyright (C) 2001, Grub, Inc.                                        */
/*  Author: Kord Campbell <kord@grub.org>                                 */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2, or (at your option)   */
/*  any later version.                                                    */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful,       */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*  GNU General Public License for more details.                          */
/*                                                                        */
/*  You should have received a copy of the GNU General Public License     */
/*  along with this program; if not, write to the                         */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,          */
/*  Boston, MA 02111-1307, USA.                                           */
/*                                                                        */
/**************************************************************************/ 

#include "grubconf.h"

/* extern this variable and set it to the proper path and file */
char *grub_config_file = NULL;

int readGrubConfig(struct Config_Info *Config_File_Info)
{

  int cfg_int;
  char *cfg_str;	/* pointer to string (stored real string is allocated dynamically.) */


  cfgStruct cfg[]={	/* this must be initialized */
	/* parameter		type		address of variable */
	{"ClientID"		,CFG_INT	,&Config_File_Info->ClientID  },
	{"AltClientID"		,CFG_UINT	,&Config_File_Info->AltClientID  },
	{"ClientPassword"	,CFG_STRING	,&Config_File_Info->ClientPassword },
	{"MaxAmountOfBandwidth"	,CFG_INT	,&Config_File_Info->MaxAmountOfBandwidth },
	{"NumOfCrawlersToRun"	,CFG_INT	,&Config_File_Info->NumOfCrawlersToRun },
	{"ThreadsPerHost"	,CFG_INT	,&Config_File_Info->ThreadsPerHost },
	{"PortNumber"		,CFG_INT	,&Config_File_Info->PortNumber },
	{"Proxy"		,CFG_STRING	,&Config_File_Info->Proxy },
	{"ProxyPort"		,CFG_INT	,&Config_File_Info->ProxyPort },
	{"GrubLogLevel"		,CFG_INT	,&Config_File_Info->GrubLogLevel },
	{NULL ,CFG_END ,NULL}	/* no more parameters */
  };

  if ( ! grub_config_file ) {

	fprintf( stderr, "grub: grub config file is not set -- BUG??\n" );
	return 1;
  }

  if (cfgParse(grub_config_file,cfg,CFG_SIMPLE)==-1){
	return 1;
  }

  return(0);
}
