#ifndef _BaseFace_H_
#define _BaseFace_H_

#include "Face.h"

class BaseFace : protected Face {
public:
	BaseFace();
	~BaseFace();

	// Posts, Rings, Events
	/////////////////////////

	virtual void EventSetBandwidth(int Bandwidth);
	virtual void EventSetCrawlerCount(int Count);

	virtual void EventGetBandwidth();
	virtual void EventGetBandwidthLimit();
	virtual void EventGetCrawlerCount();
	virtual void EventGetStatus();

	void PostGetBandwidth(int Bandwidth);
	void PostGetBandwidthLimit(int Limit);
	void PostGetCrawlerCount(int Count);
	void PostGetStatus(int Status);

	void PostGettingBegin();
	void PostGettingURL(const char *URL, int Size, int CRC);
	void PostGettingEnd();
	void PostCrawlingBegin();
	void PostCrawlingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC,
		int Bandwidth);
	void PostCrawlingURLDone(const char *URL, const char *Status);
	void PostCrawlingEnd();
	void PostPuttingBegin();
	void PostPuttingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC);
	void PostPuttingEnd();

	void PostHostProtect();
	void PostHostUnprotect();
	void PostSleep(int Seconds);

	// properties
	///////////////

	void SetPort( unsigned short new_port );
	unsigned short GetPort();

	// methods
	////////////

	void Connect();
	void Disconnect();
	void Refresh();
	bool IsConnected();

protected:
	virtual void readCallback( const char *data );
	virtual void errorCallback( const char *msg );

private:
	unsigned short port;

	DEFINE_FACE_EVENT(SetBandwidth);
	DEFINE_FACE_EVENT(SetCrawlerCount);

	DEFINE_FACE_EVENT(GetBandwidth);
	DEFINE_FACE_EVENT(GetBandwidthLimit);
	DEFINE_FACE_EVENT(GetCrawlerCount);
	DEFINE_FACE_EVENT(GetStatus);
};

#endif  /* _BaseFace_H_ */
