/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

/* Project: 	GRUB-CLIENT <http://www.grub.org>
 * module: 	Archive (crawler)
 * Author: 	Ledio Ago(lajesus@grub.org)
 * Date:	Feb 13, 2001	
 * File: 	CrawlerDb.h
 */
#ifndef _CrawlerDb_h_
#define _CrawlerDb_h_	1

#include <assert.h>
#include <unistd.h>
#include <errno.h>
#include <mk4.h>
#include <mk4str.h>
#include <stdio.h>
#include <GrubExp.h>

//URL Crawl States:
typedef enum {
	UPDATE, REDIRECT, UNCHANGED, NOTFOUND, DOWN, NOCRAWL, NOSTATUS
} status_t;

struct URLHandler {

	URLHandler();

	~URLHandler();	

	void reset();

	char *URL;
	char *content;
	int cont_len;
	unsigned long CRC;
	unsigned long size;
	char *MIME;
	char *redirURL;
	status_t status;
};

class UtilDB {
public:
	UtilDB( char *file_db);

	~UtilDB();
	
	/*
	 * Method:	GetTblSize
	 * Description:	Gets the size of the database table.
	 * Return:	Return the number of the records in the table.
	 */
	int GetTblSize( );

	/*
	 * Method:	EmptyTable
	 * Description:	It will remove all the records from the 
	 *		database table and set the size to zero.
	 */
	void EmptyTable( );

	/*
	 * Method:	Commit
	 * Description:	It will commit any changes made to the database.
	 */
	void Commit( ); 

	/* Public variables */
	int tbl_size;
	int tbl_index;
	
protected:
	/*
	 * Method: 	RemoveTopURL
	 * Description:	It will delete the top record of
	 *		the database table.
	 */
	void RemoveTopURL();

	/* Pointer to the storage location */
	c4_Storage db_storage;

	/* Pointers to the tables */
	c4_View db_tbl;
};

#endif
