/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

/* Project: 	GRUB-CLIENT <http://www.grub.org>
 * module: 	Archive (crawler)
 * Author: 	Ledio Ago(lajesus@grub.org)
 * Date:	Feb 13, 2001	
 * File: 	UtilDB.cpp
 */

#include "UtilDB.h"

URLHandler::URLHandler() : URL(0), content(0), size(0),
			CRC(0), MIME(0), redirURL(0), 
			status(NOSTATUS) {}

URLHandler::~URLHandler() {
	if ( URL ) 	delete [] URL;
	if ( content ) 	delete [] content;
	if ( MIME ) 	delete [] MIME;
	if ( redirURL ) delete [] redirURL;
	reset();
}

void URLHandler::reset() {
	
	URL 	= NULL;
	content = NULL;
	CRC 	= 0;
	size 	= 0;
	MIME 	= NULL;
	redirURL= NULL;
	status 	= NOSTATUS;
}

UtilDB::UtilDB(char *file_db) :
	db_storage(file_db, true) {}

UtilDB::~UtilDB() {}

/*
 * Method:	GetTblSize
 * Description:	Gets the size of the database table.
 * Return:	Return the number of the records in the table.
 */
int UtilDB::GetTblSize( )
{ 
	return tbl_size; 
}
/*
 * Method:	EmptyTable
 * Description:	It will remove all the records from the 
 *		database table and set the size to zero.
 */
void UtilDB::EmptyTable( )
{
	db_tbl.RemoveAll();
	Commit();
	tbl_size = 0;
}

void UtilDB::RemoveTopURL() 
{
	db_tbl.RemoveAt( 0, 1 );
	Commit();
	tbl_size--;
}

/*
 * Method:	Commit
 * Description:	It will commit any changes made to the database.
 */
void UtilDB::Commit( ) 
{
	db_storage.Commit();
}

