/* $Id: poly.h,v 1.6 2004/12/11 19:26:08 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

#ifdef __cplusplus
extern "C" {
#endif



#ifndef POLY_H
#define POLY_H

#include "geometry.h"

    typedef struct {
	Point origin;
	Point corner;
	int nverts;
	Point *verts;
	int kind;
    } Poly;

    extern void polyFree();
    extern int polyOverlap(Point, Poly *, Point, Poly *);
    extern void makePoly(Poly *, Agnode_t *, double);
    extern void breakPoly(Poly *);

#endif

#ifdef __cplusplus
}
#endif
