/*
* 21/08/2004 - 19:29
*
* GraphMonkey - mono based graphing calculator
* Copyright (C) 2004 Bellabes Lounis
* nolius@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

using System;
	


	
public class operation : object {
	public string phrase;
	public string operateur;
	public operation droite;
	public operation gauche;

	
	public operation(string phrase) {
		this.phrase=phrase;
			
	}
		
	public void decouper(){
		//on recherche un + (le plus a droite possible) qui n'est pas dans une parenthese
		int position_plus=this.phrase.LastIndexOf("+");
		bool trouver_bon_plus = false;
		while (position_plus != -1 && trouver_bon_plus==false ){
			if (this.compte_jusqua("(", position_plus) != this.compte_jusqua(")", position_plus) ){
				position_plus = this.phrase.LastIndexOf("+", position_plus-1, position_plus);
			}
			else{
				trouver_bon_plus = true;
			}
		}
		if (trouver_bon_plus == false){
			position_plus = -1;
		}
		
		//on recherche un - (le plus a droite possible) qui n'est pas dans une parenthese
		int position_moin=this.phrase.LastIndexOf("-");
		bool trouver_bon_moin = false;
		while (position_moin != -1 && trouver_bon_moin==false ){
			if (this.compte_jusqua("(", position_moin) != this.compte_jusqua(")", position_moin) ){
				position_moin = this.phrase.LastIndexOf("-", position_moin-1, position_moin);
			}
			else{
				trouver_bon_moin = true;
			}
		}
		if (trouver_bon_moin == false){
			position_moin = -1;
		}
			
		// priorit au + et -
			
		// il y a d'abord un +
		if ( (position_plus!=-1 && position_moin==-1) || (position_plus!=-1 && position_moin!=-1 && position_plus>position_moin) ){
			this.operateur = "+";
			
			string phrase_gauche=this.phrase;
			phrase_gauche = phrase_gauche.Remove(position_plus,phrase_gauche.Length-position_plus);	
			this.gauche = new operation(phrase_gauche);
			
			string phrase_droite=this.phrase;
			phrase_droite = phrase_droite.Remove(0,position_plus+1);
			this.droite = new operation(phrase_droite);				
		}
		// il y a d'abord un -
		else if ( (position_plus==-1 && position_moin!=-1) || (position_plus!=-1 && position_moin!=-1 && position_moin>position_plus) ){
			this.operateur = "-";
			
			string phrase_gauche=this.phrase;
			phrase_gauche = phrase_gauche.Remove(position_moin,phrase_gauche.Length-position_moin);	
			this.gauche = new operation(phrase_gauche);
			
			string phrase_droite=this.phrase;
			phrase_droite = phrase_droite.Remove(0,position_moin+1);
			this.droite = new operation(phrase_droite);	
	
		}
		
			
			
			
			// maintenant * et /
		else {
			//on recherche un * (le plus a doite possible) qui n'est pas dans une parenthese
			int position_multiplier=this.phrase.LastIndexOf("*");
			bool trouver_bon_multiplier = false;
			while (position_multiplier != -1 && trouver_bon_multiplier==false ){
				if (this.compte_jusqua("(", position_multiplier) != this.compte_jusqua(")", position_multiplier) ){
					position_multiplier = this.phrase.LastIndexOf("*", position_multiplier-1, position_multiplier);
				}
				else{
					trouver_bon_multiplier = true;
				}
			}
			if (trouver_bon_multiplier == false){
				position_multiplier= -1;
			}
				
			//on recherche un / (le plus a doite possible) qui n'est pas dans une parenthese
			int position_diviser=this.phrase.LastIndexOf("/");
			bool trouver_bon_diviser = false;
			while (position_diviser != -1 && trouver_bon_diviser==false ){
				if (this.compte_jusqua("(", position_diviser) != this.compte_jusqua(")", position_diviser) ){
					position_diviser = this.phrase.LastIndexOf("/", position_diviser-1, position_diviser);
				}
				else{
					trouver_bon_diviser = true;
				}
			}				
			if (trouver_bon_diviser == false){
				position_diviser= -1;
			}				
			
			
			
			
			// il ya a d'abord un *
			if ( (position_multiplier!=-1 && position_diviser==-1) || (position_multiplier!=-1 && position_diviser!=-1 && position_multiplier>position_diviser) ){ // il ya a d'abord un *
				this.operateur = "*";
					
				string phrase_gauche=this.phrase;
				phrase_gauche = phrase_gauche.Remove(position_multiplier,phrase_gauche.Length-position_multiplier);	
				this.gauche = new operation(phrase_gauche);
				
				string phrase_droite=this.phrase;
				phrase_droite = phrase_droite.Remove(0,position_multiplier+1);
				this.droite = new operation(phrase_droite);				
			}
			// il y a d'abord un /
			else if ( (position_multiplier==-1 && position_diviser!=-1) || (position_multiplier!=-1 && position_diviser!=-1 && position_diviser>position_multiplier) ){	// il ya a d'abord un /
				this.operateur = "/";
				
				string phrase_gauche=this.phrase;
				phrase_gauche = phrase_gauche.Remove(position_diviser,phrase_gauche.Length-position_diviser);	
				this.gauche = new operation(phrase_gauche);
				
				string phrase_droite=this.phrase;
				phrase_droite = phrase_droite.Remove(0,position_diviser+1);
				this.droite = new operation(phrase_droite);	
		
			}
			
			// maintenant ^ (puissance) 
			
			else{
				//on recherche un ^ (le plus a gauche possible) qui n'est pas dans une parenthese
				int position_puissance=this.phrase.IndexOf("^");
				bool trouver_bon_puissance = false;
				while (position_puissance != -1 && trouver_bon_puissance==false ){
					if (this.compte_jusqua("(", position_puissance) != this.compte_jusqua(")", position_puissance) ){
						position_puissance = this.phrase.IndexOf("^", position_puissance+1);
					}
					else{
						trouver_bon_puissance = true;
					}
				}
				if (trouver_bon_puissance == false){					
					position_puissance= -1;
				}				
							
				if ( (position_puissance!=-1) ){	// il y a un ^
					this.operateur = "^";
				
					string phrase_gauche=this.phrase;
					phrase_gauche = phrase_gauche.Remove(position_puissance,phrase_gauche.Length-position_puissance);	
					this.gauche = new operation(phrase_gauche);
				
					string phrase_droite=this.phrase;
					phrase_droite = phrase_droite.Remove(0,position_puissance+1);
					this.droite = new operation(phrase_droite);				
				}				
				else{ // si il n'y a pas de + - / * ou ^ c'est que la phrase ressemble a "(2+x-3)" ou "2" ou "x" ou r(2*x)...
			
					//si phrase par une parenthese ex: (2+x-3) on supprime les parentheses pour pouvoir continuer le calcule
					if (this.phrase.StartsWith("(")){
						this.operateur="()";
					
						string phrase_gauche=this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,1);	//on supprime le "(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin		
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("sqrt(")){	// racine
						this.operateur = "sqrt()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,5);	//on supprime le "r(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("cos(")){	// cos
						this.operateur = "cos()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,4);	//on supprime le "cos(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("sin(")){	// sin
						this.operateur = "sin()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,4);	//on supprime le "sin(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("tan(")){	// sin
						this.operateur = "tan()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,4);	//on supprime le "tan(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("n(")){	// n
						this.operateur = "n()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,2);	//on supprime le "n(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("log(")){	// log
						this.operateur = "log()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,4);	//on supprime le "log(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("acos(")){	// acos
						this.operateur = "acos()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,5);	//on supprime le "acos(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("asin(")){	// asin
						this.operateur = "asin()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,5);	//on supprime le "asin(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("atan(")){	// atan
						this.operateur = "atan()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,5);	//on supprime le "atan(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("cosh(")){	// cosh
						this.operateur = "cosh()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,5);	//on supprime le "cosh(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("sinh(")){	// sinh
						this.operateur = "sinh()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,5);	//on supprime le "sinh(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("tanh(")){	// tanh
						this.operateur = "tanh()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,5);	//on supprime le "tanh(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					else if (this.phrase.StartsWith("exp(")){	// tanh
						this.operateur = "exp()";
						
						string phrase_gauche = this.phrase;
						phrase_gauche = phrase_gauche.Remove(0,4);	//on supprime le "exp(" du debut
						phrase_gauche = phrase_gauche.Remove(phrase_gauche.Length-1,1);		//on supprime le ")" de la fin				
						this.gauche = new operation(phrase_gauche);
					}
					
					
				}
			}
		}
		
	}
		
		
	public void corrige(){
		if (this.phrase.StartsWith("-")){
			this.phrase = this.phrase.Insert(0, "0");
		}
		
		this.phrase = this.phrase.Replace("X", "x");
		this.phrase = this.phrase.Replace(".", ".");
		
		this.phrase = this.phrase.Replace("(-", "(0-");
		
		this.phrase = this.phrase.Replace("x(", "x*(");
		this.phrase = this.phrase.Replace("0(", "0*(");
		this.phrase = this.phrase.Replace("1(", "1*(");
		this.phrase = this.phrase.Replace("2(", "2*(");
		this.phrase = this.phrase.Replace("3(", "3*(");
		this.phrase = this.phrase.Replace("4(", "4*(");
		this.phrase = this.phrase.Replace("5(", "5*(");
		this.phrase = this.phrase.Replace("6(", "6*(");
		this.phrase = this.phrase.Replace("7(", "7*(");
		this.phrase = this.phrase.Replace("8(", "8*(");
		this.phrase = this.phrase.Replace("9(", "9*(");
		
		this.phrase = this.phrase.Replace(")x", ")*x");
		
		this.phrase = this.phrase.Replace("0x", "0*x");
		this.phrase = this.phrase.Replace("1x", "1*x");
		this.phrase = this.phrase.Replace("2x", "2*x");
		this.phrase = this.phrase.Replace("3x", "3*x");
		this.phrase = this.phrase.Replace("4x", "4*x");
		this.phrase = this.phrase.Replace("5x", "5*x");
		this.phrase = this.phrase.Replace("6x", "6*x");
		this.phrase = this.phrase.Replace("7x", "7*x");
		this.phrase = this.phrase.Replace("8x", "8*x");
		this.phrase = this.phrase.Replace("9x", "9*x");
			
		this.phrase = this.phrase.Replace(")(", ")*(");
		
		
	}
		
		
		
		
		
	public float calculer(float x){
		float resultat=0;
		
		//this.corrige();
		this.decouper();
		
		// cas: + - * / ^
		if(this.gauche!=null && this.droite!=null){
			if(this.operateur=="+"){
				resultat=this.gauche.calculer(x)+this.droite.calculer(x);
				return resultat;
			}
			else if(this.operateur=="*"){
				resultat=this.gauche.calculer(x)*this.droite.calculer(x);
				return resultat;
			}
			else if(this.operateur=="-"){
				resultat=this.gauche.calculer(x)-this.droite.calculer(x);
				return resultat;					
			}
			else if(this.operateur=="/"){
				resultat=this.gauche.calculer(x)/this.droite.calculer(x);
				return resultat;
			}
			else if(this.operateur=="^"){
				// il faut faire une conversion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				double droite_double = Convert.ToDouble(this.droite.calculer(x));
				resultat_double= Math.Pow(gauche_double,droite_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			
			
		}
		// cas: () r() cos() sin() tan() et n()
		else if(this.gauche!=null){
			if (this.operateur=="()"){
				resultat=this.gauche.calculer(x);
				return resultat;
			}
			else if (this.operateur=="sqrt()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Sqrt(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="cos()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Cos(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="sin()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Sin(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="tan()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Tan(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="n()"){
				resultat = 0-this.gauche.calculer(x);
				return resultat;
			}
			else if (this.operateur=="log()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Log(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="acos()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Acos(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="asin()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Asin(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="atan()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Atan(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="cosh()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Cosh(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="sinh()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Sinh(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="tanh()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Tanh(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			else if (this.operateur=="exp()"){
				// convertion
				double resultat_double;	
				double gauche_double = Convert.ToDouble(this.gauche.calculer(x));
				resultat_double= Math.Exp(gauche_double);
				resultat = (float) resultat_double;
				
				return resultat;
				
			}
			
			
		}
		
		else{ // phrase est obligatoirement de la forme "x" ou "2,1213" ou "2" 
			if (this.phrase=="x" || this.phrase=="X"){
				return x;
			}
			else{
				decimal res_d = Convert.ToDecimal(this.phrase);
				float res_f = (float) res_d;	
				resultat=res_f;
				return resultat;
		
			}
		}
		return resultat;
			
	}
	
	

		
		
		
	// exemple: compte_depuis("a", 3) de "aaaaaa" =>3
	public int compte_depuis(string ch, int debut){
		int pos;
		int nb=0;
		bool arreter=false;
		while( (debut <= this.phrase.Length) && (arreter == false) ){
			pos=phrase.IndexOf(ch,debut);
			if(pos != -1){
				nb++;
				debut=pos+1;
			}
			else{
				arreter=true;
			}
			
		}
		return nb;
	}
		
		
		
	// exemple: compte_jusqua("a", 3) de "aaaaaa" =>3
	public int compte_jusqua(string ch, int fin){
		int pos;
		int nb=0;
		bool arreter=false;
		int i=0;
		while( (i <= fin) && (arreter == false) && (i <= this.phrase.Length) ){
			pos=phrase.IndexOf(ch, i, fin-i);
			if(pos != -1){
				nb++;
				i=pos+1;
			}
			else{
				arreter=true;
			}
			
		}
		return nb;
	}
	
	
	
}
