#include <sigc++/bind.h>

#include "database-metadata.h"
#include "result-set.h"

#include "gql++/mod-result-set.h"

namespace GQL
{

namespace PG
{

using namespace std;

static gchar *table_types[][2] =
{
  { "TABLE", 		"(relkind='r' AND relname !~ '^pg_' AND relname !~ '^xinv')" },
  { "INDEX",		"(relkind='i' AND relname !~ '^pg_' AND relname !~ '^xinx')" },
  { "LARGE OBJECT",	"(relkind='r' AND relname ~ '^xinv')" },
  { "SEQUENCE", 	"(relkind='S' AND relname !~ '^pg_')" },
  { "SYSTEM TABLE", 	"(relkind='r' AND relname ~ '^pg_')" },
  { "SYSTEM INDEX", 	"(relkind='i' AND relname ~ '^pg_')" },
  { NULL,		NULL }
};

static void delete_result(ResultSet *result)
{
  delete result;
#if 0
  cout << "delete_result";
#endif
}

ResultSet *PGDatabaseMetaData::get_tables(
        const string& catalog,
        const string& schema_pattern,
        const string& table_name_pattern,
        const vector<string>& types)
{
  string query = "SELECT relname, oid FROM pg_class WHERE ";
  ResultSet *r, *dr;
  ModResultSet *result;
  bool first;
  
  first = true;
  for (vector<string>::size_type i = 0; i < types.size(); i++)
  {
    if (!first)
      query.append(" OR ");
    for (vector<string>::size_type j = 0; table_types[j][0]; j++)
      if (types[i] == table_types[j][0])
      {
        query.append(table_types[j][1]);
        first = false;
      }
  }
  query.append(" ORDER BY relname");

  r = conn_->exec_sql(query);

  result = new ModResultSet(5);
  
  while (r->next())
  {
    string name;
    SQLObject *str_obj = conn_->create_object();
    
    string *tuple[5];

    tuple[0] = 0;
    tuple[1] = 0;
    
    // Table name
    r->get(0, str_obj);
    tuple[2] = str_obj->is_null() ? 0 : new string(str_obj->to_string());

    tuple[3] = 0;
    
    // Remarks
    r->get(1, str_obj); // OID
    name = str_obj->to_string();

    query = "SELECT description FROM pg_description WHERE objoid = " + name;
    dr = conn_->exec_sql(query);
    if (dr->next())
    {
      dr->get(0, str_obj);
      tuple[4] = new string(str_obj->to_string());
    }
    else
      tuple[4] = 0;
    
    result->append(const_cast<const string **>(tuple));

    delete dr;
  }

  delete r;

  destroy.connect(SigC::bind(SigC::slot(delete_result), (ResultSet *)result));

  return(result);
}

}

}
