#include "result-set.h"
#include "result-set-metadata.h"

#include <strstream>

namespace GQL
{

namespace MySQL
{

MyResultSet::~MyResultSet()
{
  if (result_)
    mysql_free_result(result_);
}

bool MyResultSet::next() throw(SQLException)
{
  if (result_ && (int)mysql_num_rows(result_) > rowno_ + 1)
  {
    rowno_++;
    row_ = mysql_fetch_row(result_);
    return(true);
  }
  return(false);
}

void MyResultSet::get(int i, SQLObject *obj) const throw(SQLException)
{
  if (!row_)
    throw SQLException("ResultSet does not contain any data");

  if (i < 0 || i >= (int)mysql_num_fields(result_))
    throw SQLException("Attempt to access invalid field");

  if (row_[i] == 0)
    return;

  obj->from_string(row_[i]);
}

ResultSetMetaData *MyResultSet::get_meta_data()
{
  return(new MyResultSetMetaData(get_connection(), result_));
}

}

}
