/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_My_DRIVER_H)
#define __INC_My_DRIVER_H


#include "gql++/driver.h"

namespace GQL
{

namespace MySQL
{

class MyDriver : public Driver
{
  public:
    MyDriver(uC::PluginManager *mgr);

    virtual bool accept_url(const string& str) const;
    virtual Connection *connect(const string& url,
                                const map<string, string>& prop);
    virtual vector<DriverPropertyInfo> get_property_info(
            const string& url,
            const map<string, string>& props) const;

    typedef map<string, string> property_type;
    
    map<string, string> parse_url(
            const string& url,
            const map<string, string>& props = property_type()) const;
    
    const string& host() const;
    const string& port() const;
    const string& database() const;
  private:
    map<string, string> props_;
};


}
}

#endif
