/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GQL_OBJECT_H)
#define __INC_GQL_OBJECT_H

#include <string>

#include <gql++/exception.h>

namespace GQL
{

class SQLType
{
  public:
    enum TypeCode
    {
      VOID,
      BOOLEAN,
      DATE,
      DECIMAL,
      FLOAT,
      SMALLINT,
      INTEGER,
      INTERVAL,
      NUMERIC,
      TIME,
      TIME_WITH_TZ,
      TIMESTAMP_WITH_TZ,
      CHARACTER,
      CHARACTER_VARYING,
      BLOB,
      
      MAX_TYPE
    };

    SQLType();
    SQLType(TypeCode type, ...);

    TypeCode typecode() const { return(type_); }
    int length() const { return(length_); }
    int decimals() const { return(decimals_); }
  private:
    TypeCode type_;
    int length_;
    int decimals_;
};

class Blob
{
  public:
    virtual ~Blob();

    typedef enum 
    { 
      in = 0x01, 
      out = 0x02
    } openmode;
    typedef enum { beg, cur, end } seek_dir;
    
    virtual void open(openmode om = in) = 0;
    virtual bool is_open() = 0;
    virtual void close() = 0;
    
    virtual int write(const void *data, int len) = 0;
    virtual int read(void *data, int len) = 0;
    virtual int seek(int offset, seek_dir whence) = 0;
    virtual int tell() const = 0;
  protected:
    Blob() { }
};

class SQLObject
{
  public:
    SQLObject() { 
      is_null_ = true; 
      type_ = VOID; 
    }
    virtual ~SQLObject() { }
    
    void set_null() { is_null_ = true; }
    bool is_null() const { return(is_null_); }
    
    virtual string output() const;
    virtual bool   input(const string& s);

    virtual string to_string() const;
    virtual long   to_int() const;
    virtual double to_real() const;
    virtual bool   to_boolean() const;
    virtual Blob  *to_blob() const;
    
    virtual bool from_string(const string& s);
    virtual bool from_int(long l);
    virtual bool from_real(double d);
    virtual bool from_boolean(bool b);
    virtual bool from_type(const SQLType& type);
    /// if blob is 0, create a new BLOB instance
    virtual bool from_blob(const Blob *blob = 0);
  protected:
    void set_null(bool null) { is_null_ = null; }
  private:
    bool is_null_;
    
    enum { VOID, STRING, INT, FLOAT, TYPE, BLOB } type_;
    string value_;
};

}

    
#endif
