/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GDBI_CONNECTION_H)
#define __INC_GDBI_CONNECTION_H

#include <string>
#include <list>
#include <vector>

#include <gql++/connection.h>
#include <gql++/object.h>

#include <sigc++/signal_system.h>

#include "gdbi++/property.h"
#include "gdbi++/session.h"

namespace gdbi
{

class Table;

class Connection : public uC::ErrorHandler
{
  public:
    Connection(Session *session, GQL::Connection *conn,
               SigC::Tunnel *tunnel = 0, bool mt = false);
    
    ~Connection();

    const std::vector<Table *>& tables() const { return(tables_); }

    void remove_table(int pos) {
      SigC::pack(SigC::slot(this, &Connection::do_remove_table),
                 pos)->tunnel(requests_);
    }
    void add_table(Table *table) {
      SigC::pack(SigC::slot(this, &Connection::do_add_table),
                 table)->tunnel(requests_);
    }

    const PropertySchema *type_schema(const std::string& name) const;
    std::list<std::string> types() const;
    
    GQL::SQLObject *create_object() { return conn_->create_object(); }

    SigC::Tunnel *requests() { return(requests_); }
    SigC::Tunnel *signals() { return(signals_); }
    
    SigC::Signal1<void, int> table_added;
    SigC::Signal1<void, int> table_removed;

    SigC::Signal0<void> destroy;
  private:
    void do_remove_table(int i);
    void do_add_table(Table *table);
    
    GQL::Connection *conn_;
    std::vector<Table *> tables_;
    PropertySchema types_;
    
    SigC::Tunnel *requests_, *signals_;
    bool mt_;
};

typedef std::vector<Table *> TableList;


}

#endif
