/* $Id: direct.cc,v 1.1 2000/07/31 03:50:01 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2000 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <gtk/gtk.h>

#include "polling.h"
#include "importglobals.h"
#include "direct.h"

DirectMode kmode;
PipeMode pimode;
int verbose=0;
int signumber;

int direct_mode_kill(char *cmd,char *data,char *ksig) {
  int i,j,pc,sc,fc,sg;
  GList *pt;
  ProcessListItem *pli;
  char *p;
  char pidlist[768];

  switch(cmd[1]) {
  case 'n': kmode=DM_PID;  break;
  case 'u': kmode=DM_USER; break;    
  case 'g': kmode=DM_GROUP; break;
  case 's': kmode=DM_GREP_TEXT; break;
  case 'e': kmode=DM_EXACT_TEXT; break;
  default:
    cerr << "[gps] bad command string in EKM: " << cmd << endl;
    cerr << endl;
    return -1;
  }

  if (strlen(cmd)>2) {
    if (cmd[2]=='v')
      verbose=1;
    if (cmd[2]=='h')
      verbose=2;
    if (cmd[2]=='q')
      verbose=0;
  }

  pimode=DM_NONE;
  if (strlen(cmd)>3) {
    switch(cmd[3]) {
    case 'i': pimode=DM_INPUT; break;
    case 'o': pimode=DM_OUTPUT; break;
    case 'b': pimode=DM_BOTH; break;
    default:
      cerr << "[gps] bad command in EKM: " << cmd << endl;
      cerr << endl;
    }
  }

  if ((pimode==DM_BOTH)||(pimode==DM_OUTPUT))
    verbose=0;

  pidlist[0]=0;
  if ((pimode==DM_INPUT)||(pimode==DM_BOTH))
    fgets(pidlist,767,stdin);

  signumber=-256;
  for(i=0;i<POSIXSIG;i++) {
    if ((strcmp(ksig,&posixnames[i][3])==0)||
	(strcmp(ksig,posixnames[i])==0)) {
      signumber=posixvalues[i];
      break;
    }
  }
  if (signumber==-256) {
    cerr << "[gps] Not a valid signal in EKM: " << ksig;
    cerr << endl << endl;
    return -1;
  }

  // retrieve process list
  list_poller->poll();

  pc=sc=fc=0;
  for(pt=list_poller->process_list;pt!=NULL;pt=g_list_next(pt)) {
    pli=(ProcessListItem *)(pt->data);

    if (strcmp(pli->name,"gps")==0) // do not suicide!
      continue;

    if ((pimode==DM_OUTPUT)||(pimode==DM_NONE))
      sg=1;
    else
      sg=pid_in_list(pidlist,atoi(pli->pid));

    if (!sg) continue;

    p=strtok(data,"&");       

    while(p!=NULL) {             
      if (dm_match(pli,p)) {

	switch(pimode) {
	case DM_INPUT:
	case DM_NONE:	  
	  j=kill(atoi(pli->pid),signumber);
	  verb_report(pli,j);
	  if (j==0) ++sc; else ++fc;
	  ++pc;
	  break;
	case DM_OUTPUT:
	case DM_BOTH:
	  cout << atoi(pli->pid) << " ";
	  break;
	} // switch
	break; // while: report only once
	
      } // if match
      p=strtok(NULL,"&");
    }  // while (p!=NULL)
  } // for (pt...)

  switch(pimode) {
  case DM_INPUT:
  case DM_NONE:
    if (verbose>0) {
      cout << "[gps] " << pc << " processes signaled, ";
      cout << sc << " successes, " << fc << " failures." << endl;
    }
    if (pc==0) return DM_RET_NOTFOUND;
    if (pc==sc) return DM_RET_ALLKILLED;
    if (sc>0) return DM_RET_PARTIAL;
    if (sc==0) return DM_RET_FAILURE;
    return 255; // oops
  case DM_OUTPUT:
  case DM_BOTH:
    cout << endl;
  default:
    return 0;
  }
} // function

int dm_match(ProcessListItem *pli,char *what) {
  int idata;
  struct passwd *pws;
  struct group  *grs;

  switch(kmode) {
  case DM_PID:
    idata=atoi(what);
    if (atoi(pli->pid)==idata)
      return 1;
    else
      return 0;
  case DM_USER:
    if (strcmp(what,pli->owner)==0)
      return 1;
    else
      return 0;
  case DM_GROUP:
    pws=getpwnam(pli->owner);
    grs=getgrnam(what);
    if (pws->pw_gid==grs->gr_gid)
      return 1;
    else
      return 0;
  case DM_EXACT_TEXT:
    if (strcmp(what,pli->name)==0)
      return 1;
    else
      return 0;
  case DM_GREP_TEXT:
    if (strstr(pli->name,what)!=NULL)
      return 1;
    if (strstr(pli->longname,what)!=NULL)
      return 1;
    return 0;
  default:
    return 0;
  }
}

void verb_report(ProcessListItem *pli, int kres) {
  switch(verbose) {
  case 2:
    cout << "[" << pli->pid << ":" << pli->owner << ":" << pli->name << "](" << kres << ")" << endl;
    break;   
  }
}

int pid_in_list(char *plist,int v) {
  char *p,lc[768];
  if (plist==NULL)
    return 0;
  strcpy(lc,plist);
  p=strtok(lc," \n\t");
  while(p!=NULL) {
    if (atoi(p)==v) return 1;
    p=strtok(NULL," \n\t");
  }
  return 0;
}
