#
# Copyright 2008 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

SET(PRODUCT_NAME google-gadgets)

PROJECT(google_gadgets_for_linux)

IF(COMMAND CMAKE_POLICY)
  CMAKE_POLICY(SET CMP0002 OLD)
  CMAKE_POLICY(SET CMP0003 OLD)
  CMAKE_POLICY(SET CMP0005 OLD)
ENDIF(COMMAND CMAKE_POLICY)

SET(LIB_SUFFIX ""
  CACHE STRING "Define suffix of directory name (32/64)"
  FORCE)
SET(EXEC_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX}
  CACHE PATH  "Base directory for executables and libraries"
  FORCE)

# The following are directories where stuff will be installed to.
SET(BIN_INSTALL_DIR "${EXEC_INSTALL_PREFIX}/bin"
  CACHE PATH "The binary install dir (default prefix/bin)"
  FORCE)
SET(LIB_INSTALL_DIR "${EXEC_INSTALL_PREFIX}/lib${LIB_SUFFIX}"
  CACHE PATH "The subdirectory relative to the install prefix where libraries will be installed (default is /lib${LIB_SUFFIX})"
  FORCE)
SET(INCLUDE_INSTALL_DIR "${CMAKE_INSTALL_PREFIX}/include/ggadget"
  CACHE PATH "The subdirectory to the header prefix"
  FORCE)

SET(GGL_OEM_BRAND ""
  CACHE STRING "The OEM brand code")

SET(GGL_DEFAULT_BROWSER_PLUGINS_DIR "${LIB_INSTALL_DIR}/firefox/plugins"
  CACHE PATH "The directory of browser plugins.")

SET(GGL_DEFAULT_SSL_CA_FILE ""
  CACHE PATH "The SSL CA certificate file used by soup-xml-http-request")

SET(GGL_ENABLE_XDGMIME 1
  CACHE BOOL "Enable built-in xdgmime support (default is true)")

SET(LIBGGADGET_BINARY_VERSION_UNQUOTED "1.0.0")
SET(LIBGGADGET_BINARY_VERSION "\"${LIBGGADGET_BINARY_VERSION_UNQUOTED}\"")
SET(GGL_MAJOR_VERSION 0)
SET(GGL_MINOR_VERSION 11)
SET(GGL_MICRO_VERSION 2)
SET(GGL_VERSION_UNQUOTED "${GGL_MAJOR_VERSION}.${GGL_MINOR_VERSION}.${GGL_MICRO_VERSION}")
SET(GGL_VERSION "\"${GGL_VERSION_UNQUOTED}\"")
SET(GGL_EPOCH "-1.0")

# The library version number is different than package version.
# The number should follow the rule defined by libtool and use the same number
# defined in configure.ac, eg.:
# LIBGGADGET_CURRENT, LIBGGADGET_REVISION and LIBGGADGET_AGE
# It's just a temporary value, because the API is not stable yet.
SET(GGL_LIB_VERSION "0.0.0")
SET(GGL_LIB_SOVERSION "0")

# This string is used in auto update request. It should be updated to the
# time of a release build is made. Its format is yymmdd-HHMMSS.
SET(GGL_VERSION_TIMESTAMP "\"100127-000000\"")

# Define the version of Google Desktop Gadget API that this release supports.
SET(GGL_API_MAJOR_VERSION 5)
SET(GGL_API_MINOR_VERSION 8)
SET(GGL_API_VERSION_UNQUOTED "${GGL_API_MAJOR_VERSION}.${GGL_API_MINOR_VERSION}.0.0")
SET(GGL_API_VERSION "\"${GGL_API_VERSION_UNQUOTED}\"")

IF(NOT CMAKE_BUILD_TYPE)
  SET(CMAKE_BUILD_TYPE "Release")
ENDIF(NOT CMAKE_BUILD_TYPE)

IF("${CMAKE_BUILD_TYPE}" STREQUAL "debugfull"
    OR "${CMAKE_BUILD_TYPE}" STREQUAL "debug")
  SET(CMAKE_BUILD_TYPE "Debug")
ENDIF("${CMAKE_BUILD_TYPE}" STREQUAL "debugfull"
    OR "${CMAKE_BUILD_TYPE}" STREQUAL "debug")

SET(GGL_HOST_TYPE linux)
SET(GGL_PLATFORM_SHORT "\"linux\"")
SET(GGL_PLATFORM "\"linux\"")

INCLUDE(CheckFunctionExists)
INCLUDE(GGLCheckFunctionExists)
INCLUDE(FindPkgConfig)
INCLUDE(CheckIncludeFile)

INCLUDE(CheckTypeSize)
SET(HAVE_STDDEF_H 1)
CHECK_TYPE_SIZE(char GGL_SIZEOF_CHAR)
CHECK_TYPE_SIZE(short GGL_SIZEOF_SHORT_INT)
CHECK_TYPE_SIZE(int GGL_SIZEOF_INT)
CHECK_TYPE_SIZE(long GGL_SIZEOF_LONG_INT)
CHECK_TYPE_SIZE(size_t GGL_SIZEOF_SIZE_T)
CHECK_TYPE_SIZE(double GGL_SIZEOF_DOUBLE)
CHECK_TYPE_SIZE(wchar_t GGL_SIZEOF_WCHAR_T)

CONFIGURE_FILE(${CMAKE_SOURCE_DIR}/ggadget/sysdeps.h.in
               ${CMAKE_BINARY_DIR}/ggadget/sysdeps.h)

IF("${CMAKE_BUILD_TYPE}" STREQUAL "Debug"
    AND EXISTS ${CMAKE_SOURCE_DIR}/CTestConfig.cmake)
  INCLUDE(Dart)
  SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fprofile-arcs -ftest-coverage")
  SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fprofile-arcs -ftest-coverage")
ENDIF("${CMAKE_BUILD_TYPE}" STREQUAL "Debug"
    AND EXISTS ${CMAKE_SOURCE_DIR}/CTestConfig.cmake)

INCLUDE(CopyUtils)
INCLUDE(GenerateOutput)
INCLUDE(PkgConfigEx)
INCLUDE(TestSuite)
INCLUDE(ZipUtils)
INCLUDE(DistInfo)

SET(prefix "${CMAKE_INSTALL_PREFIX}")
SET(exec_prefix "${EXEC_INSTALL_PREFIX}")
SET(libdir "${LIB_INSTALL_DIR}")
SET(includedir "${prefix}/include")
SET(datarootdir "${prefix}/share")
SET(datadir "${datarootdir}")
SET(sysconfdir "${prefix}/etc")

SET(GGL_MODULE_DIR "${LIB_INSTALL_DIR}/${PRODUCT_NAME}/modules")
SET(GGL_RESOURCE_DIR "${CMAKE_INSTALL_PREFIX}/share/${PRODUCT_NAME}")
SET(GGL_LIBEXEC_DIR "${LIB_INSTALL_DIR}/${PRODUCT_NAME}")
SET(GGL_INCLUDE_DIR "${CMAKE_INSTALL_PREFIX}/include/${PRODUCT_NAME}")
SET(GGL_SYSDEPS_INCLUDE_DIR "${LIB_INSTALL_DIR}/${PRODUCT_NAME}/include")

ADD_DEFINITIONS(
  -DUNIX
  -DPREFIX=${CMAKE_INSTALL_PREFIX}
  -DPRODUCT_NAME=${PRODUCT_NAME}
  # For stdint.h macros like INT64_C etc.
  -D__STDC_CONSTANT_MACROS
  # TODO: only for Linux by now
  -DGGL_HOST_LINUX
  -DGGL_MODULE_DIR=\\\"${GGL_MODULE_DIR}\\\"
  -DGGL_RESOURCE_DIR=\\\"${GGL_RESOURCE_DIR}\\\"
  -DGGL_LIBEXEC_DIR=\\\"${GGL_LIBEXEC_DIR}\\\"
  -DGGL_DIST_INFO=\"\\\"${GGL_DIST_INFO}\\\"\")

IF(GGL_OEM_BRAND)
  ADD_DEFINITIONS(-DGGL_OEM_BRAND=\"\\\"${GGL_OEM_BRAND}\\\"\")
ENDIF(GGL_OEM_BRAND)

IF(GGL_DEFAULT_BROWSER_PLUGINS_DIR)
  ADD_DEFINITIONS(-DGGL_DEFAULT_BROWSER_PLUGINS_DIR=\\\"${GGL_DEFAULT_BROWSER_PLUGINS_DIR}\\\")
ENDIF(GGL_DEFAULT_BROWSER_PLUGINS_DIR)

IF(GGL_DEFAULT_SSL_CA_FILE)
  ADD_DEFINITIONS(-DGGL_DEFAULT_SSL_CA_FILE=\\\"${GGL_DEFAULT_SSL_CA_FILE\\\")
ENDIF(GGL_DEFAULT_SSL_CA_FILE)

INCLUDE(CheckCCompilerFlag)
IF(UNIX)
  SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -Wall -Werror -Wconversion -Wextra")
  # No "-Wall -Werror" for C flags, to avoid third_party code break.
  SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fPIC")
  SET(PROJECT_RESOURCE_DIR share/${PRODUCT_NAME})
ELSE(UNIX)
  SET(PROJECT_RESOURCE_DIR resource)
ENDIF(UNIX)
# SET(CMAKE_SKIP_RPATH ON)
ENABLE_TESTING()

IF("${CMAKE_BUILD_TYPE}" STREQUAL "Debug")
  ADD_DEFINITIONS(-D_DEBUG)
  CHECK_C_COMPILER_FLAG(-fstack-protector-all GCC_STACK_PROTECTOR_ALL)
  IF(GCC_STACK_PROTECTOR_ALL)
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fstack-protector-all")
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fstack-protector-all")
  ENDIF(GCC_STACK_PROTECTOR_ALL)
ELSE("${CMAKE_BUILD_TYPE}" STREQUAL "Debug")
  ADD_DEFINITIONS(-DNDEBUG)
  CHECK_C_COMPILER_FLAG(-fstack-protector GCC_STACK_PROTECTOR)
  IF(GCC_STACK_PROTECTOR)
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fstack-protector")
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fstack-protector")
  ENDIF(GCC_STACK_PROTECTOR)
ENDIF("${CMAKE_BUILD_TYPE}" STREQUAL "Debug")

INCLUDE_DIRECTORIES(${CMAKE_SOURCE_DIR})
INCLUDE_DIRECTORIES(${CMAKE_BINARY_DIR})

SET(GGL_BUILD_GTK_HOST 1)
SET(GGL_BUILD_QT_HOST 0)
SET(GGL_BUILD_LIBGGADGET_DBUS 1)
SET(GGL_BUILD_LIBGGADGET_GTK 1)
SET(GGL_BUILD_LIBGGADGET_QT 0)
SET(GGL_BUILD_LIBGGADGET_NPAPI 1)
SET(GGL_BUILD_QTWEBKIT_BROWSER_ELEMENT 0)
SET(GGL_BUILD_QT_SCRIPT_RUNTIME 0)
SET(GGL_BUILD_GTKMOZ_BROWSER_ELEMENT 1)
SET(GGL_BUILD_GTK_EDIT_ELEMENT 1)
SET(GGL_BUILD_GTK_FLASH_ELEMENT 1)
SET(GGL_BUILD_GST_AUDIO_FRAMEWORK 1)
SET(GGL_BUILD_GST_VIDEO_ELEMENT 1)
SET(GGL_BUILD_SMJS_SCRIPT_RUNTIME 1)
SET(GGL_BUILD_CURL_XML_HTTP_REQUEST 1)
SET(GGL_BUILD_SOUP_XML_HTTP_REQUEST 1)
SET(GGL_BUILD_LIBXML2_XML_PARSER 1)
SET(GGL_BUILD_LINUX_SYSTEM_FRAMEWORK 1)
SET(GGL_BUILD_WEBKIT_SCRIPT_RUNTIME 1)
SET(GGL_BUILD_GTKWEBKIT_BROWSER_ELEMENT 1)

# Check if flex is installed
FIND_PROGRAM(FLEX flex)
IF(NOT FLEX)
  MESSAGE(FATAL_ERROR "flex is needed to build ggl")
ENDIF(NOT FLEX)

# Check if zip is installed
FIND_PROGRAM(ZIP zip)
IF(NOT ZIP)
  MESSAGE(FATAL_ERROR "zip is needed to build ggl")
ENDIF(NOT ZIP)

# Check necessary functions
CHECK_FUNCTION_EXISTS(mkdtemp HAVE_MKDTEMP)
IF(HAVE_MKDTEMP)
  ADD_DEFINITIONS(-DHAVE_MKDTEMP)
ENDIF(HAVE_MKDTEMP)

CHECK_FUNCTION_EXISTS(mmap HAVE_MMAP)
IF(HAVE_MMAP)
  ADD_DEFINITIONS(-DHAVE_MMAP)
ENDIF(HAVE_MMAP)

# Check necessary libraries.

# Check if libltdl-dev is installed
FIND_FILE(LTDL ltdl.h)
IF(NOT LTDL)
  MESSAGE(FATAL_ERROR "libltdl development package is needed to build ggl")
ENDIF(NOT LTDL)

FIND_PACKAGE(ZLIB REQUIRED)

FIND_PACKAGE(Threads)
IF(CMAKE_USE_PTHREADS_INIT)
  SET(PTHREAD_FOUND 1)
  SET(PTHREAD_LIBRARIES ${CMAKE_THREAD_LIBS_INIT})
  ADD_DEFINITIONS(-DHAVE_PTHREAD=1)
ENDIF(CMAKE_USE_PTHREADS_INIT)

FIND_PACKAGE(X11)
IF(X11_FOUND)
  GET_CONFIG(xt 1.0 XT XT_FOUND)
  ADD_DEFINITIONS(-DHAVE_X11=1)
ELSE(X11_FOUND)
  SET(GGL_BUILD_GTKMOZ_BROWSER_ELEMENT 0)
  SET(GGL_BUILD_GTK_FLASH_ELEMENT 0)
  SET(GGL_BUILD_LIBGGADGET_NPAPI 0)
ENDIF(X11_FOUND)

GET_CONFIG(libxml-2.0 2.6.0 LIBXML2 LIBXML2_FOUND)
IF(NOT LIBXML2_FOUND AND GGL_BUILD_LIBXML2_XML_PARSER)
  MESSAGE("Library libxml2 is not available, libxml2-xml-parser extension won't be built.")
  SET(GGL_BUILD_LIBXML2_XML_PARSER 0)
ENDIF(NOT LIBXML2_FOUND AND GGL_BUILD_LIBXML2_XML_PARSER)

GET_CONFIG(libcurl 7.15 LIBCURL LIBCURL_FOUND)
IF(NOT LIBCURL_FOUND)
  IF(GGL_BUILD_CURL_XML_HTTP_REQUEST)
    MESSAGE("Library curl is not available, curl-xml-http-request extension won't be built.")
    SET(GGL_BUILD_CURL_XML_HTTP_REQUEST 0)
  ENDIF(GGL_BUILD_CURL_XML_HTTP_REQUEST)
ENDIF(NOT LIBCURL_FOUND)

GET_CONFIG(libsoup-2.4 2.26.0 LIBSOUP LIBSOUP_FOUND)
IF(NOT LIBSOUP_FOUND)
  IF(GGL_BUILD_SOUP_XML_HTTP_REQUEST)
    MESSAGE("Library soup is not available, soup-xml-http-request extension won't be built.")
    SET(GGL_BUILD_SOUP_XML_HTTP_REQUEST 0)
  ENDIF(GGL_BUILD_SOUP_XML_HTTP_REQUEST)
ELSE(NOT LIBSOUP_FOUND)
  GET_CONFIG(libsoup-gnome-2.4 2.26.0 LIBSOUP_GNOME LIBSOUP_GNOME_FOUND)
  IF(LIBSOUP_GNOME_FOUND)
    LIST(APPEND LIBSOUP_DEFINITIONS "-DHAVE_LIBSOUP_GNOME")
  ENDIF(LIBSOUP_GNOME_FOUND)
  SET(CMAKE_REQUIRED_INCLUDES ${LIBSOUP_INCLUDE_DIR})
  SET(CMAKE_REQUIRED_LIBRARIES ${LIBSOUP_LIBRARIES})
  CHECK_FUNCTION_EXISTS(soup_message_headers_get_one SOUP_MESSAGE_HEADERS_GET_ONE_FOUND)
  IF(SOUP_MESSAGE_HEADERS_GET_ONE_FOUND)
    LIST(APPEND LIBSOUP_DEFINITIONS "-DHAVE_SOUP_MESSAGE_HEADERS_GET_ONE")
  ENDIF(SOUP_MESSAGE_HEADERS_GET_ONE_FOUND)
ENDIF(NOT LIBSOUP_FOUND)

GET_CONFIG(gstreamer-base-0.10 0.10.0 GSTREAMER GSTREAMER_FOUND)
GET_CONFIG(gstreamer-plugins-base-0.10 0.10.0 GSTREAMER_PLUGINS_BASE GSTREAMER_PLUGINS_BASE_FOUND)
IF(GSTREAMER_FOUND AND GSTREAMER_PLUGINS_BASE_FOUND)
  FIND_LIBRARY(VIDEOSINK_LIBRARY NAMES gstvideo-0.10 PATH /usr/lib /usr/lib/gstreamer-0.10 /usr/local/lib /usr/local/lib/gstreamer-0.10)
  IF(VIDEOSINK_LIBRARY)
    SET(GSTREAMER_VIDEO_LIBRARIES "${GSTREAMER_LIBRARIES}  -lgstvideo-0.10")
  ELSE(VIDEOSINK_LIBRARY)
    MESSAGE("Libgstreamer-plugins-base-dev is not available, gst-video-element extension won't be built.")
    SET(GGL_BUILD_GST_VIDEO_ELEMENT 0)
  ENDIF(VIDEOSINK_LIBRARY)
ELSE(GSTREAMER_FOUND AND GSTREAMER_PLUGINS_BASE_FOUND)
  IF(GGL_BUILD_GST_AUDIO_FRAMEWORK)
    MESSAGE("Library gstreamer-plugins-base(>=0.10.0) is not available, gst-audio-framework extension won't be built.")
    SET(GGL_BUILD_GST_AUDIO_FRAMEWORK 0)
  ENDIF(GGL_BUILD_GST_AUDIO_FRAMEWORK)
  IF(GGL_BUILD_GST_VIDEO_ELEMENT)
    MESSAGE("Library gstreamer-plugins-base(>=0.10.0) is not available, gst-video-element extension won't be built.")
    SET(GGL_BUILD_GST_VIDEO_ELEMENT 0)
  ENDIF(GGL_BUILD_GST_VIDEO_ELEMENT)
ENDIF(GSTREAMER_FOUND AND GSTREAMER_PLUGINS_BASE_FOUND)

GET_CONFIG(pango 1.10.0 PANGO PANGO_FOUND)
GET_CONFIG(cairo 1.0.0 CAIRO CAIRO_FOUND)
GET_CONFIG(fontconfig 2.0 FONTCONFIG FONTCONFIG_FOUND)
GET_CONFIG(glib-2.0 2.10.0 GLIB2 GLIB2_FOUND)
GET_CONFIG(gdk-2.0 2.8.0 GDK2 GDK2_FOUND)
GET_CONFIG(gtk+-2.0 2.8.0 GTK2 GTK2_FOUND)
GET_CONFIG(gthread-2.0 2.8.0 GTHREAD GTHREAD_FOUND)
IF(NOT PANGO_FOUND OR NOT CAIRO_FOUND OR NOT FONTCONFIG_FOUND OR NOT GLIB2_FOUND OR NOT GDK2_FOUND OR NOT GTK2_FOUND OR NOT GTHREAD_FOUND)
  SET(GGL_BUILD_LIBGGADGET_GTK 0)
  SET(GGL_BUILD_GTK_HOST 0)
  SET(GGL_BUILD_GTK_EDIT_ELEMENT 0)
  SET(GGL_BUILD_GTK_FLASH_ELEMENT 0)
  SET(GGL_BUILD_GTKMOZ_BROWSER_ELEMENT 0)
  MESSAGE("Library cairo, pango, fontconfig or gtk-2.0 are not available, gtk-system-framework extension, libggadget-gtk, gtk host won't be built.")
ENDIF(NOT PANGO_FOUND OR NOT CAIRO_FOUND OR NOT FONTCONFIG_FOUND OR NOT GLIB2_FOUND OR NOT GDK2_FOUND OR NOT GTK2_FOUND OR NOT GTHREAD_FOUND)

GET_CONFIG(librsvg-2.0 2.14 RSVG RSVG_FOUND)
IF(RSVG_FOUND)
  LIST(APPEND RSVG_DEFINITIONS "-DHAVE_RSVG_LIBRARY")
ENDIF(RSVG_FOUND)

# Check Qt

SET(QT_MIN_VERSION 4.3.0)
SET(QT_USE_QTWEBKIT 1)
SET(QT_USE_QTNETWORK 1)
FIND_PACKAGE(Qt4)

IF(QT4_FOUND AND QT_QTCORE_FOUND AND QT_QTGUI_FOUND)
  INCLUDE(${QT_USE_FILE})
  SET(QT_LINK_DIR ${QT_LIBRARY_DIR})
  SET(QT_LIBRARIES ${QT_QTCORE_LIBRARY} ${QT_QTGUI_LIBRARY})
  SET(GGL_BUILD_LIBGGADGET_QT 1)
  SET(GGL_BUILD_QT_HOST 1)

  PKG_CHECK_MODULES(QT_QTSCRIPT QtScript>=4.4.0)
  IF(QT_QTSCRIPT_FOUND)
    LIST(APPEND QT_LIBRARIES ${QT_QTSCRIPT_LIBRARIES})
    SET(GGL_BUILD_QT_SCRIPT_RUNTIME 1)
  ELSE(QT_QTSCRIPT_FOUND)
    MESSAGE("Qt 4.4 or above is not available, QtScriptRuntime won't be built.")
  ENDIF(QT_QTSCRIPT_FOUND)

  IF(NOT QT_QTWEBKIT_FOUND)
    PKG_CHECK_MODULES(QT_QTWEBKIT QtWebKit)
    IF(QT_QTWEBKIT_FOUND)
      SET(QT_QTWEBKIT_LIBRARY ${QT_QTWEBKIT_LIBRARIES})
    ENDIF(QT_QTWEBKIT_FOUND)
  ENDIF(NOT QT_QTWEBKIT_FOUND)

  IF(QT_QTWEBKIT_FOUND)
    LIST(APPEND QT_LIBRARIES ${QT_QTWEBKIT_LIBRARIES})
    INCLUDE_DIRECTORIES(${QT_QTWEBKIT_INCLUDE_DIRS})
    SET(GGL_BUILD_QTWEBKIT_BROWSER_ELEMENT 1)
  ELSE(QT_QTWEBKIT_FOUND)
    MESSAGE("QtWebKit is needed to build qtwebkit_browser_element")
  ENDIF(QT_QTWEBKIT_FOUND)
ELSE(QT4_FOUND AND QT_QTCORE_FOUND AND QT_QTGUI_FOUND)
  MESSAGE("Library qt-4.3 or above is not available, libggadget-qt, qt host and qt related extensions won't be built.")
ENDIF(QT4_FOUND AND QT_QTCORE_FOUND AND QT_QTGUI_FOUND)

GET_CONFIG(dbus-1 1.0 DBUS DBUS_FOUND)
IF(NOT DBUS_FOUND AND GGL_BUILD_LIBGGADGET_DBUS)
  SET(GGL_BUILD_LIBGGADGET_DBUS 0)
  MESSAGE("Library D-Bus is not available, libggadget-dbus won't be built.")
ELSE(NOT DBUS_FOUND AND GGL_BUILD_LIBGGADGET_DBUS)
  LIST(APPEND DBUS_DEFINITIONS "-DHAVE_DBUS_LIBRARY")
  SET(CMAKE_REQUIRED_INCLUDES ${DBUS_INCLUDE_DIR})
  SET(CMAKE_REQUIRED_LIBRARIES ${DBUS_LIBRARIES})
  CHECK_FUNCTION_EXISTS(dbus_watch_get_unix_fd DBUS_UNIX_FD_FUNC_FOUND)
  IF(DBUS_UNIX_FD_FUNC_FOUND)
    LIST(APPEND DBUS_DEFINITIONS "-DHAVE_DBUS_WATCH_GET_UNIX_FD")
  ENDIF(DBUS_UNIX_FD_FUNC_FOUND)
ENDIF(NOT DBUS_FOUND AND GGL_BUILD_LIBGGADGET_DBUS)

GET_CONFIG(NetworkManager 0.7 NETWORK_MANAGER NETWORK_MANAGER_FOUND)
IF(NETWORK_MANAGER_FOUND)
  SET(GGL_HAVE_NETWORK_MANAGER 1)
  LIST(APPEND NETWORK_MANAGER_DEFINITIONS
    "-DHAVE_NETWORK_MANAGER" "-DHAVE_NEW_NETWORK_MANAGER_API")
ELSE(NETWORK_MANAGER_FOUND)
  GET_CONFIG(NetworkManager 0.6 NETWORK_MANAGER NETWORK_MANAGER_OLD_FOUND)
  IF(NETWORK_MANAGER_OLD_FOUND)
    SET(GGL_HAVE_NETWORK_MANAGER 1)
    LIST(APPEND NETWORK_MANAGER_DEFINITIONS "-DHAVE_NETWORK_MANAGER")
  ENDIF(NETWORK_MANAGER_OLD_FOUND)
ENDIF(NETWORK_MANAGER_FOUND)

# Check gtkmozembed (Please refer to configure.ac)
# Check priority:
#  xulrunner 1.9: libxul-embedding-unstable and mozilla-js
#  xulrunner 1.8: xulrunner-gtkmozembed and xulrunner-js
#  firefox 2.0: firefox2-gtkmozembed and firefox2-js
#  firefox 1.5: firefox-gtkmozembed and firefox-js
#  seamonkey 1.1: seamonkey-gtkmozembed seamonkey-js
#  microb(Maemo): microb-engine and microb-engine-js
#
# Add more rules here if your distribution doesn't support above rules.
MACRO(HASH_PUT _hash _key _value)
  LIST(APPEND ${_hash} ${_key})
  SET(__${_hash}_${_key}__ ${_value})
ENDMACRO(HASH_PUT _hash _key _value)

MACRO(HASH_GET _hash _key _value)
  SET(${_value} ${__${_hash}_${_key}__})
ENDMACRO(HASH_GET _hash _key _value)

# We need to check xul if smjs runtime is to be built because we prefer
# to using smjs through glue mechanism provided by xul
IF(GGL_BUILD_LIBGGADGET_GTK OR GGL_BUILD_SMJS_SCRIPT_RUNTIME)
  HASH_PUT(xul_hash libxul-embedding-unstable mozilla-js)
  HASH_PUT(xul_hash libxul-embedding mozilla-js)
  HASH_PUT(xul_hash xulrunner-gtkmozembed xulrunner-js)
  HASH_PUT(xul_hash firefox2-gtkmozembed firefox2-js)
  HASH_PUT(xul_hash firefox-gtkmozembed firefox-js)
  HASH_PUT(xul_hash seamonkey-gtkmozembed seamonkey-js)
  HASH_PUT(xul_hash microb-engine microb-engine-js)

  FOREACH(pkg ${xul_hash})
    IF(NOT GTKMOZEMBED_FOUND)
      GET_CONFIG(${pkg} 0 GTKMOZEMBED GTKMOZEMBED_FOUND)
      IF(GTKMOZEMBED_FOUND)
        PKG_GET_VARIABLE(${pkg} "includedir" EMBED_INCDIR)
        LIST(APPEND GTKMOZEMBED_INCLUDE_DIR
          ${EMBED_INCDIR}
          ${EMBED_INCDIR}/content
          ${EMBED_INCDIR}/dom
          ${EMBED_INCDIR}/xpconnect
          ${EMBED_INCDIR}/widget
          ${EMBED_INCDIR}/gtkembedmoz
          ${EMBED_INCDIR}/xpcom
          ${EMBED_INCDIR}/string)
        HASH_GET(xul_hash "${pkg}" LIBSMJS)
        GET_CONFIG(${LIBSMJS} 0 SMJS SMJS_FOUND)
        IF(SMJS_FOUND)
          SET(SMJS_NAME ${LIBSMJS})
        ENDIF(SMJS_FOUND)
      ENDIF(GTKMOZEMBED_FOUND)
    ENDIF(NOT GTKMOZEMBED_FOUND)
  ENDFOREACH(pkg ${PKG_NAMES})

  IF(NOT GTKMOZEMBED_FOUND AND GGL_BUILD_GTKMOZ_BROWSER_ELEMENT)
    SET(GGL_BUILD_GTKMOZ_BROWSER_ELEMENT 0)
    MESSAGE("Library GtkMozEmbed is not available, gtkmoz-browser-element extension won't be built.")
  ENDIF(NOT GTKMOZEMBED_FOUND AND GGL_BUILD_GTKMOZ_BROWSER_ELEMENT)

ENDIF(GGL_BUILD_LIBGGADGET_GTK OR GGL_BUILD_SMJS_SCRIPT_RUNTIME)

# If xpglue fail, try legacy standalone smjs library.
IF(NOT SMJS_FOUND)
  INCLUDE(SpiderMonkey)
ENDIF(NOT SMJS_FOUND)

# Hell, some distributions' package of smjs is broken. We have to fix it here
IF(SMJS_FOUND)
  STRING(REGEX MATCH "/stable" RESULT "${SMJS_INCLUDE_DIR}")
  IF("${RESULT}" STREQUAL "/stable")
    PKG_GET_VARIABLE(${SMJS_NAME} "includedir" SMJS_INC)
    FIND_FILE(JSAPI_PATH jsapi.h "${SMJS_INC}/unstable")
    IF(JSAPI_PATH)
      LIST(APPEND SMJS_INCLUDE_DIR "${SMJS_INC}/unstable")
    ENDIF(JSAPI_PATH)
  ENDIF("${RESULT}" STREQUAL "/stable")

  SET(CMAKE_REQUIRED_INCLUDES ${SMJS_INCLUDE_DIR})
  SET(CMAKE_REQUIRED_LIBRARIES ${SMJS_LIBRARIES})
  SET(CMAKE_REQUIRED_LINK_DIR ${SMJS_LINK_DIR})
  SET(CMAKE_REQUIRED_DEFINITIONS ${SMJS_DEFINITIONS})
  CHECK_INCLUDE_FILE(jsversion.h JSVERSION_H_FOUND)
  IF(JSVERSION_H_FOUND)
    LIST(APPEND SMJS_DEFINITIONS "-DHAVE_JSVERSION_H")
  ENDIF(JSVERSION_H_FOUND)
  GGL_CHECK_FUNCTION_EXISTS(JS_SetOperationCallback JS_SETOPERATIONCALLBACK_FOUND)
  IF(JS_SETOPERATIONCALLBACK_FOUND)
    LIST(APPEND SMJS_DEFINITIONS "-DHAVE_JS_SetOperationCallback")
  ENDIF(JS_SETOPERATIONCALLBACK_FOUND)
  GGL_CHECK_FUNCTION_EXISTS(JS_TriggerAllOperationCallbacks JS_TRIGGERALLOPERATIONCALLBACKS_FOUND)
  IF(JS_TRIGGERALLOPERATIONCALLBACKS_FOUND)
    LIST(APPEND SMJS_DEFINITIONS "-DHAVE_JS_TriggerAllOperationCallbacks")
  ENDIF(JS_TRIGGERALLOPERATIONCALLBACKS_FOUND)
ENDIF(SMJS_FOUND)

IF(SMJS_FOUND AND GTKMOZEMBED_FOUND)
  STRING(REGEX MATCH "XPCOM_GLUE" RESULT "${GTKMOZEMBED_DEFINITIONS}")
  IF("${RESULT}" STREQUAL "XPCOM_GLUE")
    MESSAGE("Using XPCOM_GLUE for SMJS")
    LIST(APPEND SMJS_DEFINITIONS ${GTKMOZEMBED_DEFINITIONS})
    LIST(APPEND SMJS_INCLUDE_DIR ${GTKMOZEMBED_INCLUDE_DIR})
    SET(SMJS_LIBRARIES ${GTKMOZEMBED_LIBRARIES})
    SET(SMJS_LINK_DIR ${GTKMOZEMBED_LINK_DIR})
  ENDIF("${RESULT}" STREQUAL "XPCOM_GLUE")
ENDIF(SMJS_FOUND AND GTKMOZEMBED_FOUND)

IF(NOT SMJS_FOUND AND GGL_BUILD_SMJS_SCRIPT_RUNTIME)
  SET(GGL_BUILD_SMJS_SCRIPT_RUNTIME 0)
  MESSAGE("Library SpiderMonkey is not available, smjs-script-runtime extension won't be built.")
ENDIF(NOT SMJS_FOUND AND GGL_BUILD_SMJS_SCRIPT_RUNTIME)

# Check WebKit/JavaScriptCore
GET_CONFIG(webkit-1.0 1.0.3 GTKWEBKIT GTKWEBKIT_FOUND)
IF(GTKWEBKIT_FOUND)
  IF(GGL_BUILD_WEBKIT_SCRIPT_RUNTIME)
    # Just copy the config of GTKWEBKIT to JAVA_SCRIPT_CORE.
    GET_CONFIG(webkit-1.0 1.0.3 JAVA_SCRIPT_CORE JAVA_SCRIPT_CORE_FOUND) 
    SET(JAVA_SCRIPT_CORE_DEFINITIONS
      "${JAVA_SCRIPT_CORE_DEFINITIONS} -DHAVE_JAVA_SCRIPT_H")
    SET(GTKWEBKIT_DEFINITIONS
      "${GTKWEBKIT_DEFINITIONS} -DGGL_GTK_WEBKIT_SUPPORT_JSC -DHAVE_JAVA_SCRIPT_H")
  ENDIF(GGL_BUILD_WEBKIT_SCRIPT_RUNTIME)
ENDIF(GTKWEBKIT_FOUND)

IF(NOT GTKWEBKIT_FOUND AND GGL_BUILD_GTKWEBKIT_BROWSER_ELEMENT)
  SET(GGL_BUILD_GTKWEBKIT_BROWSER_ELEMENT 0)
  MESSAGE("Library WebKit is not available, gtkwebkit-browser-element extension won't be built.")
ENDIF(NOT GTKWEBKIT_FOUND AND GGL_BUILD_GTKWEBKIT_BROWSER_ELEMENT)

IF(NOT JAVA_SCRIPT_CORE_FOUND AND GGL_BUILD_WEBKIT_SCRIPT_RUNTIME)
  SET(GGL_BUILD_WEBKIT_SCRIPT_RUNTIME 0)
  MESSAGE("Library JavaScriptCore is not available, webkit-script-runtime extension won't be built.")
ENDIF(NOT JAVA_SCRIPT_CORE_FOUND AND GGL_BUILD_WEBKIT_SCRIPT_RUNTIME)

MESSAGE("
Build options:
  Version                          ${GGL_VERSION}
  Build type                       ${CMAKE_BUILD_TYPE}
  OEM brand                        ${GGL_OEM_BRAND}

 Libraries:
  GTK SVG Support                  ${RSVG_FOUND}
  Build libggadget-gtk             ${GGL_BUILD_LIBGGADGET_GTK}
  Build libggadget-qt              ${GGL_BUILD_LIBGGADGET_QT}
  Build libggadget-dbus            ${GGL_BUILD_LIBGGADGET_DBUS}
  Build libggadget-npapi           ${GGL_BUILD_LIBGGADGET_NPAPI}

 Extensions:
  Build curl-xml-http-request      ${GGL_BUILD_CURL_XML_HTTP_REQUEST}
  Build soup-xml-http-request      ${GGL_BUILD_SOUP_XML_HTTP_REQUEST}
  Build dbus-script-class          ${GGL_BUILD_LIBGGADGET_DBUS}
  Build gst-audio-framework        ${GGL_BUILD_GST_AUDIO_FRAMEWORK}
  Build gst-video-element          ${GGL_BUILD_GST_VIDEO_ELEMENT}
  Build gtkmoz-browser-element     ${GGL_BUILD_GTKMOZ_BROWSER_ELEMENT}
  Build libxml2-xml-parser         ${GGL_BUILD_LIBXML2_XML_PARSER}
  Build linux-system-framework     ${GGL_BUILD_LINUX_SYSTEM_FRAMEWORK}
  Build gtk-edit-element           ${GGL_BUILD_GTK_EDIT_ELEMENT}
  Build gtk-flash-element          ${GGL_BUILD_GTK_FLASH_ELEMENT}
  Build gtk-system-framework       ${GGL_BUILD_LIBGGADGET_GTK}
  Build gtkwebkit-browser-element  ${GGL_BUILD_GTKWEBKIT_BROWSER_ELEMENT}
  Build qt-edit-element            ${GGL_BUILD_LIBGGADGET_QT}
  Build qt-script-runtime          ${GGL_BUILD_QT_SCRIPT_RUNTIME}
  Build qt-system-framework        ${GGL_BUILD_LIBGGADGET_QT}
  Build qt-xml-http-request        ${GGL_BUILD_LIBGGADGET_QT}
  Build qtwebkit-browser-element   ${GGL_BUILD_QTWEBKIT_BROWSER_ELEMENT}
  Build smjs-script-runtime        ${GGL_BUILD_SMJS_SCRIPT_RUNTIME}
  Build webkit-script-runtime      ${GGL_BUILD_WEBKIT_SCRIPT_RUNTIME}

 Hosts:
  Build gtk host                   ${GGL_BUILD_GTK_HOST}
  Build qt host                    ${GGL_BUILD_QT_HOST}
")
