#include <efi.h>
#include <efilib.h>

EFI_STATUS
efi_main (EFI_HANDLE image, EFI_SYSTEM_TABLE *systab)
{
	EFI_LOADED_IMAGE *loaded_image;
	EFI_DEVICE_PATH *dev_path;

	InitializeLib(image, systab);
	BS->HandleProtocol(image, &LoadedImageProtocol, (void **) &loaded_image);
	BS->HandleProtocol(loaded_image->DeviceHandle, &DevicePathProtocol, (void **) &dev_path);

	Print(L"Image device      : %s\n", DevicePathToStr(dev_path));
	Print(L"Image file        : %s\n", DevicePathToStr(loaded_image->FilePath));
	Print(L"Image base        : %X\n", loaded_image->ImageBase);
	Print(L"Image size        : %X\n", loaded_image->ImageSize);
	Print(L"Load options size : %X\n", loaded_image->LoadOptionsSize);
	Print(L"Load options      : %s\n", loaded_image->LoadOptions);

	return EFI_SUCCESS;
}
