/* $Id: rbgnome-client.c,v 1.2 2000/03/30 15:13:14 iga Exp $ */

/* Gnome::Client - GNOME session management client support
 *
 * Copyright (C) 1998 Carsten Schaar
 *
 * Author: Carsten Schaar <nhadcasc@fs-maphy.uni-hannover.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 */

#include "rbgnome.h"

/*
 * Class Gnome::Client
 */

VALUE gnoClient;

static VALUE
rbgnome_master_client(self)
    VALUE self;
{
    GnomeClient* client;
    client = gnome_master_client();
    return make_gobject(gnoClient, GTK_OBJECT(client));
}

static VALUE
client_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE do_connect;
    GnomeClient* client;
    rb_scan_args(argc, argv, "01", &do_connect);
    if (NIL_P(do_connect) || RTEST(do_connect)) {
	client = gnome_client_new();
    } else {
	client = gnome_client_new_without_connection();
    }
    set_gobject(self, GTK_OBJECT(client));
    return Qnil;
}

static VALUE
client_get_config_prefix(self)
    VALUE self;
{
    gchar *prefix;
    prefix = gnome_client_get_config_prefix(GNOME_CLIENT(get_gobject(self)));
    return rb_str_new2(prefix);
}

static VALUE
client_get_global_config_prefix(self)
    VALUE self;
{
    gchar *prefix;
    prefix = gnome_client_get_global_config_prefix(
		GNOME_CLIENT(get_gobject(self)));
    return rb_str_new2(prefix);
}

static VALUE
client_set_global_config_prefix(self, prefix)
    VALUE self, prefix;
{
    gnome_client_set_global_config_prefix(
	GNOME_CLIENT(get_gobject(self)), STR2CSTR(prefix));
    return self;
}

#if 0
get_flags

set_restart_style(style)

set_priority(priority)

set_restart_command(arg, ...)

add_static_arg(...)

set_discard_command(arg, ...)

set_resign_command(arg, ...)

set_shutdown_command(arg, ...)

set_current_directory(dir)

set_environment(name, value)

set_clone_command(arg, ...)

set_process_id(pid)

set_program(program)

set_user_id(user_id)

save_any_dialog(dialog)

save_error_dialog(dialog)

request_phase_2

request_save(save_style, shutdown, interact_style, fast, global)

flush

disable_master_connection

connected?
#endif

void
Init_gnome_client()
{
    gnoClient = rb_define_class_under(mGnome, "Client", gObject);

    rb_define_module_function(mGnome, "master_client",
			      rbgnome_master_client, 0);

    /*
     * instance methods
     */
    rb_define_method(gnoClient, "initialize", client_initialize, -1);
    rb_define_method(gnoClient, "config_prefix",
		     client_get_config_prefix, 0);
    rb_define_method(gnoClient, "global_config_prefix",
		     client_get_global_config_prefix, 0);
    rb_define_method(gnoClient, "global_config_prefix=",
		     client_set_global_config_prefix, 1);
}
