/*
 *  Copyright 2004-2006 Michael Terry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GTK_MULT_H__
#define __GTK_MULT_H__

#include <gtkmm.h>
#include "MultPuzzle.h"

class GtkMult
	: public Gtk::Window
{
	public:
	
	GtkMult (void);
	~GtkMult (void);
	
	private:
	
	MultPuzzle *puzzle;
	Gtk::Widget *table;
	Gtk::VBox *vbox;
	Gtk::Statusbar *status;
	Gtk::Label *score;
	
	bool cheated;
	
	void new_puzzle (void);
	void update_score (void);
	virtual void on_puzzle_guess (char digit, char letter, int response);
	virtual void on_menu_deselect (void);
	virtual void on_menu_game_quit (void);
	virtual void on_menu_select_quit (void);
	virtual void on_menu_game_new (void);
	virtual void on_menu_select_new (void);
	virtual void on_menu_game_solve (void);
	virtual void on_menu_select_solve (void);
	virtual void on_menu_help_about (void);
	virtual void on_menu_select_about (void);
};

#endif /* __GTK_MULT_H__ */
