#!/bin/sh
#
#	$Id: do_examples.sh,v 1.14 2008/05/01 01:42:26 guru Exp $
#
# Bourne script to test all GMT examples (sh versions).
# If one argument is given it is used as the bin path
# If a second arguemnt is used it is added to the library path

# Temporary change LANG to C
LANG=C

# First determine if awk is buggy:

result=`echo 1 | awk '{print sin($1)}'`
if [ $result = 1 ]; then	# awk is rotten
	if [ `type nawk | grep "not found" | wc -l` -eq 1 ]; then
		AWK=gawk
	else
		AWK=nawk
	fi
else
	AWK=awk
fi
export AWK

# Extend executable and library path if requested

if [ $# -ge 1 ]; then
	cd ..
	top=`pwd`
	cd examples
	PATH=$1:$PATH
	export PATH
	if [ $# = 2 ]; then
		LD_LIBRARY_PATH=$2:${LD_LIBRARY_PATH:-/usr/lib}
		export LD_LIBRARY_PATH
	fi
fi

# Loop over all examples and run each job

for ex in ex??/job*.sh
do
	printf "Doing example %s ... " $ex
	cd `dirname $ex`
	gmtdefaults -Du > .gmtdefaults4
	sh `basename $ex`
	\rm -f .gmtdefaults4 .gmtcommands4
	cd ..
	echo "done"
done

echo "Completed all examples"
