.TH MGD77CONVERT GMTMANSECTION "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
mgd77convert \- Translate between different formats of MGD77 files
.SH SYNOPSIS
\fBmgd77convert\fP \fINGDC-ids\fP \fB\-Fa\fP|\fBb\fP|\fBt\fP \fB\-T\fP[\fB+\fP]\fBa\fP|\fBb\fP|\fBt\fP 
[ \fB\-L\fP[\fBw\fP][\fBe\fP][\fB+\fP] ] [ \fB\-V\fP ] [ \fB\-4\fP ]
.SH DESCRIPTION
\fBmgd77convert\fP reads versions of MGD77 files and writes the same
data in (probably) another format to a new file in the current directory.
.TP
\fINGDC-ids\fP
Can be one or more of five kinds of specifiers:
.br
1) 8-character NGDC IDs, e.g., 01010083, JA010010etc., etc.
.br
2) 2-character <agency> codes which will return all cruises from each agency.
.br
3) 4-character <agency><vessel> codes, which will return all cruises from those vessels.
.br
4) =<list>, where <list> is a table with NGDC IDs, one per line.
.br
5) If nothing is specified we return all cruises in the data base.
.br
(See mgd77info \fB\-F\fP for agency and vessel codes).
The ".mgd77" or ".nc" extensions will automatically be appended, if needed (use \fB\-I\fP
to ignore certain file types).  Cruise files will be looked for first in the current directory
and second in all directories listed in \fB$MGD77_HOME\fP/mgd77_paths.txt [If \fB$MGD77_HOME\fP
is not set it will default to \fB$GMTHOME\fP/share/mgd77].
.br
NOTE: Under Windows, only (1) and (4) are currently supported.
.TP
.B \-F
Specifies the format of the input (From) files.  Choose from \fBa\fP for standard
MGD77 ASCII table (with extension .mgd77), \fBb\fP for the new MGD77+ netCDF format
(with extension .nc), and \fBt\fP for a plain ASCII tab-separated table dump
(with extension .dat).
.TP
.B \-T
Specifies the format of the output (To) files.  Choose from \fBa\fP for standard
MGD77 ASCII table (with extension .mgd77), \fBb\fP for the new MGD77+ netCDF format
(with extension .nc), and \fBt\fP for a plain ASCII tab-separated table dump
(with extension .dat).  We will refuse to create the file(s) if they already
exist in the current directory.  Prepend \fB+\fP to override this policy.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-L
Set the level of verification reporting [none] and where to send such reports [stderr].
Append a combination of \fBw\fP for warnings, \fBe\fP for errors, and \fB+\fP to send
such log information to stdout.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-4
By default, the storage types used in a MGD77+ netCDF file greatly exceed the precision
imposed by the ASCII MGD77 format.  However, for the five items \fBfaa\fP, \fBeot\fP,
\fBmag\fP, \fBdiur\fP and \fBmsd\fP we use 2-byte integers with implied precisions of 0.1 mGal,
0.1 nTesla, and 1 m as in the MGD77 format.  It is possible that at some point these items will
need to be stored as 4-byte ints which would allow precisions of 1 fTesla, 1 nGal, and 0.01 mm,
respectively.  This option activates such storage [Default uses 2-byte integers].
.SH EXAMPLES
To convert 01010047.mgd77 and 01010008.mgd77 to new netCDF .nc files, and
capture all verification messages, try
.br
.sp
\fBmgd77convert\fP 01010047 01010008 \fB\-Fa \-Tc \-V \-Lew+\fP > log.lis
.br
.sp
To convert 01010047.nc back to MGD77 ASCII and make sure it is identical to the
original file, try (Bourne shell syntax)
.br
.sp
orig=`\fBmgd77path\fP 01010047 \fB\-Ic\fP`
.br
\fBmgd77convert\fP 01010047 \fB\-Fc \-Ta \-V\fP
.br
diff $orig 01010047.mgd77
.br
.sp
To convert 01010047.nc to a plain ASCII table for manual editing, overwriting any existing table, try
.br
.sp
\fBmgd77convert\fP 01010047 \fB\-Fc \-T+t \-V\fP
.SH FILE FORMATS
\fBmgd77convert\fP handles three different formats. (1) The MGD77 ASCII tables are
the established standard for distribution of underway geophysical data to and from the
NGDC data center.  Normally, only the ship-operations people and the cruise PI might
be involved in \fImaking\fP an MGD77 ASCII file for transmission to NGDC; users
are more interested in \fIreading\fP such files. (2) The MGD77+ netCDF format was
developed to fascilitate the use of MGD77 data by scientists.  It contains all the information
of the original MGD77 file and if you convert back and forth you end up with the original.
However, file sizes are typically ~30% of the original ASCII format and is much faster to
operate on. (3) The plain ASCII tab-separated dump is available for users who need to
manually edit the content of a MGD77 file.  This is usually easier to do when the columns
are tab-separated than when they are all crunched together in the MGD77 punch-card format.
.SH OTHER TOOLS
The MGD77+ netCDF files are CF-1.0 and COARDS compliant and can be examined with general-purpose
tools such as ncBrowse and ncView.
.SH "SEE ALSO"
.IR mgd77manage (GMTMANSECTION),
.IR mgd77list (GMTMANSECTION),
.IR mgd77sample (GMTMANSECTION),
.IR mgd77track (GMTMANSECTION)
.IR x2sys_init (GMTMANSECTION)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2005, The Generic Mapping Tools (GMT) version
4.1 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
ncBrowse, see \fIhttp://www.epic.noaa.gov/java/ncBrowse/\fP
.br
ncView, see \fIhttp://meteora.ucsd.edu/~pierce/ncview_home_page.html\fP
.br
The Marine Geophysical Data Exchange Format - "MGD77", see
\fIhttp://www.ngdc.noaa.gov/mgg/dat/geodas/docs/mgd77.txt\fP
.br
