.TH PSPOLAR GMTMANSECTION "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
\fBpspolar\fP\ - Plot polarities on the inferior focal half\-sphere on maps
.SH SYNOPSIS
.br
pspolar \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP]
\fB\-D\fP\fIlon\fP/\fIlat\fP \fB\-M\fP\fIsize\fP \fB\-S\fP\fI<symbol><size>\fP
[ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-C\fP\fIlon\fP/\fIlat\fP[/\fIdash_width\fP/\fIpointsize\fP] ] 
[ \fB\-F\fP\fIcolor\fP ] [ \fB\-G\fP\fIfill\fP ] [ \fB\-g\fP\fIfill\fP ] 
[ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-h\fP ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-s\fP\fIHalf-size\fP[\fBv\fP[[\fIv_width\fP/\fIh_length\fP/\fIh_width\fP/\fIshape\fP]][\fBg\fP[\fIcolor\fP]][\fBl\fP]
[ \fB\-T\fP\fIangle\fP/\fIform\fP/\fIjustify\fP/\fIfontsize\fP ] [ \fB\-t\fP\fIpen\fP ]
[ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ]
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
.br
\fBpspolar\fP reads data values from \fIfiles\fP [or standard input]
and generates \fIPostScript\fP code that will plot stations on focal mechanisms
on a map.
The \fIPostScript\fP code is written to standard output.
.br
.sp
Parameters are expected to be in the following columns
.TP
.B 1,2,3,4
station_code, azimuth, take-off angle, polarity
.br
.sp
polarity:
.br
- compression can be c,C,u,U,+
.br
- rarefaction can be d,D,r,R,-
.br
- not defined is anything else
.br
.sp
.SH ARGUMENTS
\fIfiles\fP
List one or more file-names. If no files are given, pspolar will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.TP
\fB\-D\fIlongitude/latitude\fP
Maps the bubble at given longitude and latitude point.
.br
.TP
\fB\-M\fIsize\fP
Sets the size of the beach ball to plot polarities in.  \fISize\fP is in inch
(unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
.br
.TP
\fB\-S\fI<symbol_type><size>\fP
Selects \fIsymbol_type\fP and symbol \fIsize\fP.  
Size is in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
Choose symbol type from
st(\fIa\fP)r, (\fIc\fP)ircle, (\fId\fP)iamond, (\fIh\fP)exagon,
(\fIi\fP)nverted triangle, (\fIp\fP)oint, (\fIs\fP)quare, (\fIt\fP)riangle,
(\fIx\fP)cross.
.br
.LP
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
\fB\-C\fP
Offsets focal mechanisms to the latitude and longitude specified in the last
two columns of the input file.
.br
.TP
\fB\-E\fIfill\fP
\fRSelects filling of symbols for stations in extensive quadrants.
Set the shade (0\-255) or color (r/g/b) [Default is 250/250/250].
If \fB\-E\fP\fIfill\fP is the same as \fB\-F\fP\fIfill\fP, use \fB\-e\fP to outline.
.br
.TP
\fB\-e\fI[pen]\fP
Outline symbols in extensive quadrants using \fIpen\fP or the default pen (see
\fB\-W\fP).
.br
.TP
\fB\-F\fP\fIfill\fP
Sets background color of the beach ball. Default is no fill.
.br
.TP
\fB\-f\fI[pen]\fP
Outline the beach ball using \fIpen\fP or the default pen (see \fB\-W\fP).
.br
.TP
\fB\-G\fP\fIfill\fP
Selects filling of symbols for stations in compressional quadrants.
Set the shade (0\-255) or color (r/g/b) [Default is 0/0/0].
.br
.TP
\fB\-g\fI[pen]\fP
Outline symbols in compressional quadrants using \fIpen\fP or the default pen
(see \fB\-W\fP).
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
\fB\-h\fP
Use special format derived from HYPO71 output
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside map border [Default plots points inside border only].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
\fB\-s\fP\fIhalf\-size/[\fBV\fP[\fIv_width/h_length/h_width/shape\fP]][\fBG\fP\fIr/g/b\fP][\fBL\fP]
.br
Plots S polarity azimuth.
.br
S polarity is in last column.
It may be a vector (\fBV\fP option) or a segment. 
Give half\-size,v_width,h_length,h_width in inch
(unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
[\fBL\fP] option is for outline.
.br
.TP
\fB\-T\fP\fIangle/form/justify/fontsize in points\fP
.br
To write station code. [Default is 0.0/0/5/12].
.br
.TP
\fB\-t\fIpen\fP
Set pen color to write station code. Default uses the default pen (see
\fB\-W\fP).
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
\fB\-W\fP
Set current pen attributes 
 [Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.br
.SH EXAMPLES
.sp
\fBpspolar\fP \fB\-R\fP239/240/34/35.2 \fB\-JM\fP8 \fB\-N\fP \fB\-Sc\fP0.4 \fB\-H\fP1 \fB\-D\fP239.5/34.5 \fB\-M\fP5 <<END>! test.ps
.br
stat azim  ih pol
.br
0481   11  147   c
.br
6185  247  120   d
.br
0485  288  114   +
.br
0490  223  112   -
.br
0487  212  109   .
.br
END
.br
or
.br
\fBpspolar\fP \fB\-R\fP239/240/34/35.2 \fB\-JM\fP8 \fB\-N\fP \fB\-Sc\fP0.4 \fB\-H\fP1 \fB\-D\fP239.5/34.5 \fB\-M\fP5 \fB\-h\fP <<END>! test.ps
.br
Date   Or. time stat azim  ih                                    
.br
910223   1 22   0481   11  147   ipu0
.br
910223   1 22   6185  247  120   ipd0
.br
910223   1 22   0485  288  114   epu0
.br
910223   1 22   0490  223  112   epd0
.br
910223   1 22   0487  212  109   epu0
.br
END
.br
.sp
.SH "SEE ALSO"
.IR GMT (GMTMANSECTION),
.IR psbasemap (GMTMANSECTION),
.IR psxy (GMTMANSECTION)
.SH REFERENCES
.br
\fRBomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismology, Freeman, 1980.
.SH AUTHORS
\fRGenevieve Patau
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@ipgp.jussieu.fr)
.br
