.TH PSCOUPE GMTMANSECTION "15 May 2006" "GMT4.1.2" "GMT4.1.2"   
.SH NAME
pscoupe \- Plot cross-sections of focal mechanisms. 
.SH SYNOPSIS
.br
\fBpscoupe\fP \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP]
\fB\-A\fP\fIparameters\fP [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ]  [ \fB\-F\fP\fIfill\fP ]
[ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ]
[ \fB\-K\fP ] [ \fB\-L\fP\fI[pen]\fP ] [ \fB\-M\fP ] [ \fB\-N\fP ] [ \fB\-O\fP ] 
[ \fB\-P\fP ] [ \fB\-S\fP\fI<symbol><scale>\fP[/\fBd\fP] ]
[ \fB\-s\fP\fI<symbol><size>\fP[/\fBd\fP] ] [ \fB\-T\fP\fIn\fP ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ]
[ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ]
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-Z\fP\fIcpt\fP ]
[ \fB\-a\fP[\fIsize\fP/[\fIP_symbol\fP/[\fIT_symbol\fP]]] ]
[ \fB\-g\fP\fIfill\fP ] [ \fB\-e\fP\fIfill\fP ] [ \fB\-p\fP\fIpen\fP ]
[ \fB\-t\fP\fIpen\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
.br
\fBpscoupe\fP reads data values from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot symbols, lines or polygons on a cross-section.
Focal mechanisms  may be specified and require additional columns of data.
The \fIPostScript\fP code is written to standard output. 
.sp
\fIfiles\fP list one or more file-names. If no files are given, \fBpscoupe\fP
will read standard input.
.sp
A \fInew file\fP is created with the new coordinates (\fBx\fP, \fBy\fP) and the
mechanism (from lower focal half-sphere for horizontal plane, to half-sphere
behind a vertical plane).
When the plane is not horizontal,
- north direction becomes upwards steepest descent direction of the plane (u)
- east direction becomes strike direction of the plane (s)
- down direction (= north^east) becomes u^s
.br
Axis angles are defined in the same way as in horizontal plane in the new system.
.br
Moment tensor (initially in r, t, f system that is up, south, east)
is defined in (-u^s, -u, s) system.
A \fI file\fP  is created with extracted events.
.sp 
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
If frame is defined from cross-section parameters (see \fB-A\fP) this option is not taken into account,
but must be present.
.TP
\fB\-A\fP  selects the cross-section.
.br
\fB\-Aa\fP\fIlon1/lat1/lon2/lat2/dip/p_width/dmin/dmax\fP[\fBf\fP]
.br
\fIlon\fP and \fIlat\fP are the longitude and latitude of points 1 and 2 limiting the length ot the cross-section.
.br
\fIdip\fP is the dip of the plane on which the cross-section is made.
.br
\fIp_width\fP is the width of the cross-section on each side of a vertical plane
or above and under an oblique plane. 
.br
\fIdmin\fP and \fIdmax\fP are the distances min and max from horizontal plane, 
along steepest descent direction.
.br
Add \fBf\fP to get the frame from the cross-section parameters.
.br
\fB\-Ab\fP\fIlon1/lat1/strike/p_length/dip/p_width/dmin/dmax\fP[\fBf\fP]
.br
\fIlon1\fP and \fIlat1\fP are the longitude and latitude of the beginning of the cross-section.
.br
\fIstrike\fP is the azimut of the direction of the cross-section.
.br
\fIp_length\fP is the length along which the cross-section is made.
.br
The other parameters are the same as for \fB-Aa\fP option.
.br
\fP\-Ac\fP\fIx1/y1/x2/y2/dip/p_width/dmin/dmax\fP[\fBf\fP]
.br
The same as \fB\-Aa\fP option with \fIx\fP and \fIy\fP cartesian coordinates.
.br
\fB\-Ad\fP\fIx1/y1/strike/p_length/dip/p_width/dmin/dmax\fP[\fBf\fP]
.br
The same as \fB\-Ab\fP option with \fIx\fP and \fIy\fP cartesian coordinates.
.br
.TP
.B \-S
selects the meaning of the columns in the data file and the figure to be plotted.
.TP
\fB\-Sa\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]]
Focal mechanisms in Aki and Richard convention.
\fIscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude.  The \fIscale\fP is the size for
magnitude = 5 in \fBMEASURE_UNIT\fP (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is
appended to indicate that the size information is in units of cm, inches,
meters, or points, respectively).  Use the \fB\-T\fP option
to render the beach ball transparent by drawing only the nodal planes
and the circumference.  The color or shade of the compressive
quadrants can be specified with the \fB\-G\fP option.  The color or shade
of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns:
.sp
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6\fP:
strike, dip and rake
.IP \fB7\fP:
magnitude
.IP \fB8,9\fP:
not used; can be 0 0; allows use of the psmeca file format
.IP \fB10\fP:
text string to appear above the beach ball (default) or under (add \fBu\fP).
.sp
.TP
\fB\-Sc\fIscale\fP
Focal mechanisms in Harvard CMT convention.  
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. The \fIscale\fP is the size for magnitude = 5
(that is M0 = 4E+23 dynes-cm.) in \fBMEASURE_UNIT\fP (unless \fBc\fP, \fBi\fP,
\fBm\fP, or \fBp\fP is appended to indicate that the size information is in
units of cm, inches, meters, or points, respectively).  Use the \fB\-T\fP option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive quadrants
can be specified with the \fB\-G\fP option.  The color or shade
of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6\fP:
strike, dip, and slip of plane 1
.IP \fB7,8,9\fP:
strike, dip, and slip of plane 2
.IP \fB10,11\fP:
mantissa and exponent of moment in dyne-cm (if magnitude is uses instead of scalar moment, magnitude is in column 10 and 0 must be in column 11)
.IP \fB12,13\fP:
not used; can be 0 0; allows use of the psmeca file format
.IP \fB14\fP:
text string to appear above the beach ball (default) or under (add \fBu\fP).
.sp
.TP
\fB\-Sp\fB\fIscale[/fontsize[/offset\fP[\fBu\fP]]]
Focal mechanisms given with partial data on both planes.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude.  The \fIscale\fP is the size for magnitude
= 5 in \fBMEASURE_UNIT\fP (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inches, meters, or
points, respectively).  The color or shade of the compressive quadrants
can be specified with the \fB\-G\fP option.  The color or shade of the extensive
quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth
.IP \fB4,5\fP:
strike, dip of plane 1
.IP \fB6\fP:
strike of plane 2
.IP \fB7\fP:
must be -1/+1 for a normal/inverse fault
.IP \fB8\fP:
magnitude
.IP \fB9,10\fP:
not used; can be 0 0; allows use of the psmeca file format
.IP \fB11\fP:
text string to appear above the beach ball (default) or under (add \fBu\fP).
.sp
.TP
\fB\-Sm\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]]
Seismic moment tensor.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. The \fIscale\fP is the size for magnitude = 5
(that is seismic scalar moment = 4E+23 dynes-cm) in \fBMEASURE_UNIT\fP (unless
\fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended to indicate that the size
information is in units of cm, inches, meters, or points, respectively).
(\fB\-T\fP\fI0\fP option overlays best double couple transparently.) Put
\fB\-Sd\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]] to plot the only double couple part
of moment tensor.  Put \fB\-Sz\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]] to plot
anisotropic part of moment tensor (zero trace).  The color or shade of the
compressive quadrants can be specified with the \fB\-G\fP option.  The color or
shade of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6,7,8,9\fP:
mrr, mtt, mff, mrt, mrf, mtf in 10*exponent dynes-cm
.IP \fB10\fP:
exponent
.IP \fB11,12\fP:
Not used; can be 0 0; allows use of the psmeca file format
.IP \fB13\fP:
Text string to appear above the beach ball (default) or under (add \fBu\fP).
.br
.sp
.TP
\fB\-Sx\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]]
Principal axis.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. The \fIscale\fP is the size for magnitude = 5
(that is seismic scalar moment = 4*10e+23 dynes-cm) in \fBMEASURE_UNIT\fP (unless
\fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended to indicate that the size
information is in units of cm, inches, meters, or points, respectively).
(\fB-T\fP\fI0\fP option overlays best double couple transparently.) Put
\fB\-Sy\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]] to plot the only double couple part
of moment tensor.  Put \fB\-St\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]] to plot
anisotropic part of moment tensor (zero trace).  The color or shade of the
compressive quadrants can be specified with the \fB\-G\fP option.  The color or
shade of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6,7,8,9,10,11,12\fP:
value (in 10*exponent dynes-cm), azimuth, plunge of the T, N, and P axes.
.IP \fB13\fP:
exponent
.IP \fB14,15\fP:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fP option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2.  The \fB\-:\fP option will interchange the order of
columns (1,2) and (9,10).
.IP \fB16\fP:
Text string to appear above the beach ball (optional).
.br
.TP
\fB\-s\fP\fIsymbol[size[/fontsize[/offset\fP[\fBu\fP]]]
selects a symbol instead of mechanism.
Choose from the following:
(\fBc\fP) circle, (\fBd\fP) diamond, (\fBi\fP) itriangle, (\fBs\fP) square, (\fBt\fP) triangle, (\fBx\fP) cross.
\fIsize\fP is the symbol size in \fBMEASURE_UNIT\fP (unless \fBc\fP, \fBi\fP,
\fBm\fP, or \fBp\fP is appended to indicate that the size information is in
units of cm, inches, meters, or points, respectively).  If \fIsize\fP must be
read, it must be in column 4 and the text string will start in column 5.
Parameters are expected to be in the following columns:
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4\fP:
Text string to appear above the beach ball (default) or under (add \fBu\fP).
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.br
.TP
\fB\-E\fP\fIfill\fP
\fRSelects filling of extensive quadrants. Usually white.
Set the shade (0\-255) or color (r/g/b) [Default is 255/255/255].
.br
.TP
\fB\-G\fP\fIfill\fP
Selects filling of focal mechanisms. By convention, the
compressional quadrants are shaded.  Set the shade (0\-255) or color
(\fIr/g/b\fP) [Default is \fP0/0/0\fP].  Optionally, specify
\fB\-Gp\fP\fIicon_size/pattern\fP, where \fPpattern\fP gives the
number of the image pattern (1-90) OR the name of a Sun rasterfile.
\fPicon_size\fP sets the unit size in inches.  To invert black and
white pixels, use \fB\-GP\fP instead of \fP\-Gp\fP.  See
Appendix E for information on individual patterns.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
\fB\-L\fP[\fIpen\fP]
\fRDraws the "beach ball" outline using current pen (see \fB\-W\fP) or sets pen attributes.
.br
.TP
.B \-M
Same size for any magnitude.
.br
.TP
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside map border [Default plots points inside border only].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.br
.TP
\fB\-T\fP[\fInum_of_planes\fP]
\fRPlots the nodal planes and outlines the bubble which is transparent.
If \fInum_of_planes\fP is
.br
      \fI0\fP: both nodal planes are plotted;
      \fI1\fP: only the first nodal plane is plotted;
      \fI2\fP: only the second nodal plane is plotted 
[Default: 0].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.br
.TP
.B \-W
set pen attributes for text string or default pen attributes for fault plane edges. [Defaults: width = \fI1\fP, color = \fP0/0/0\fP, texture = \fPsolid\fP]. 
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
\fB\-Z\fIcptfile
\fRGive a color palette file and let compressive part color be determined by the z-value in the
third column.
.br
.TP
\fB\-a\fP[\fIsize\fP/[\fIP_axis_symbol\fP/[\fIT_axis_symbol\fP]]]
Computes and plots P and T axes with symbols. Optionally specify \fIsize\fP
and (separate) P and T axis symbols from the following:
(\fBc\fP) circle, (\fBd\fP) diamond, (\fBh\fP) hexagon,
(\fBi\fP) inverse triangle,
(\fBp\fP)point, (\fBs\fP) square, (\fBt\fP) triangle,
(\fBx\fP) cross. [Defaults: 0.2\fBc\fP/\fBc\fP/\fBc\fP or 0.08\fBi\fP/\fBc\fP/\fBc\fP.]
.br
.TP
\fB\-e\fP\fIfill\fP
\fRSelects filling of T axis symbol.
Set the shade (0\-255) or color (r/g/b) [Default is color of extensive parts.] 
.br
.TP
\fB\-g\fP\fIfill\fP
\fRSelects filling of P axis symbol.
Set the shade (0\-255) or color (r/g/b) [Default is color of compressive parts.]
.br
.TP
\fB\-p\fP[\fIpen\fP]
\fRDraws the P axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.br
.TP
\fB\-t\fP[\fIpen\fP]
\fRDraws the T axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH "SEE ALSO"
.IR GMT (GMTMANSECTION),
.IR psbasemap (GMTMANSECTION),
.IR psmeca (GMTMANSECTION),
.IR psxy (GMTMANSECTION)
.sp
.SH REFERENCES
.br
Bomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismology, Freeman, 1980.
.br
F. A. Dahlen and Jeoren Trom, Theoretical Seismology, Princeton, 1998, p.167.
Definition of scalar moment.
.br
Cliff Frohlich, Cliff's Nodes Concerning Plotting Nodal Lines for P, Sh and Sv\"'
.br
Seismological Research Letters, Volume 67, Number 1, January-February, 1996
.br
Thorne Lay, Terry C. Wallace, Modern Global Seismology, Academic Press, 1995, p.384.
.br
W.H. Press, S.A. Teukolsky, W.T. Vetterling, B.P. Flannery, Numerical Recipes in C, Cambridge University press (routine jacobi)
.br
.sp
.SH AUTHOR
.br
\fRGenevieve Patau
.br
CNRS UMR 7580
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@ipgp.jussieu.fr)
