.TH XYZ2GRD l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
xyz2grd \- Converting an ASCII or binary table to grd file format
.SH SYNOPSIS
\fBxyz2grd\fP \fIxyzfile\fP \fB\-G\fP\fIgrdfile\fP \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] 
\fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] [ \fB\-A\fP[\fBn|z|u|l\fP] ] [ \fB\-D\fP\fIxname\fP/\fIyname\fP/\fIzname\fP/\fIscale\fP/\fIoffset\fP/\fItitle\fP/\fIremark\fP ] 
[ \fB\-E\fP[\fInodata\fP] ] [ \fB\-F\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-N\fP\fInodata\fP ] [ \fB\-S\fP[\fIzfile\fP] ] [ \fB\-V\fP ] 
[ \fB\-Z\fP[\fIflags\fP] ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBxyz2grd\fP reads a z or xyz table and
creates a binary grdfile.  \fBxyz2grd\fP will report if some of the nodes are not filled in with
data.  Such unconstrained nodes are set to a value specified by the user [Default is NaN].
Nodes with more than one value will be set to the average value.  As an option (using \fB\-Z\fP),
a 1-column z-table may be read assuming all nodes are present (z-tables can be in organized in a
number of formats, see \fB\-Z\fP below.)
.TP
\fI[xy]zfile\fP
ASCII [or binary] file holding z or (x,y,z) values.  xyz triplets do not
have to be sorted (for binary triplets, see \fB\-b\fP).  1-column z tables must be sorted and the \fB\-Z\fP must be set). 
.TP
.B \-G
\fIgrdfile\fP is the name of the binary output grdfile.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
.sp
.TP
.B \-A
Add up multiple values that belong to the same node (same as \fB\-Az\fP).
Append \fBn\fP to simply count the number of data points that were assigned to each node.
Append \fBl\fP or \fBu\fP to find the lowest (minimum) or upper (maximum) value at each node, respectively. 
[Default (no \fB\-A\fP option) will calculate mean value].  Ignored if \fB\-Z\fP is given.
.TP
.B \-D
Give values for \fIxname, yname, zname, scale, offset, title,\fP and \fIremark\fP.
To leave some of these values untouched, specify = as the value.
.TP
.B \-E
Convert an ESRI ArcInfo ASCII interchange grid format file to a \fBGMT\fP grid.  Append \fInodata\fP which is a data
value that should be set to NaN in the grid [Default is to read the optional 6th record in the file and get \fInodata\fP].
The values normally given by \fB\-R\fP, \fB\-I\fP, and \fB\-F\fP are determined from the ESRI header instead.
.TP
.B \-F
Force pixel registration [Default is grid registration].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
Not used with binary data.
.TP
.B \-N
No data.  Set nodes with no input xyz triplet to this value [Default is NaN].  For z-tables, this
option is used to replace z-values that equal \fInodata\fP with NaN.
.TP
.B \-S
Swap the byte-order of the input only.  No grid file is produced.  You must
also supply the \fB\-Z\fP option.  The output is written to \fIzfile\fP (or
stdout if not supplied).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-Z
Read a 1-column ASCII [or binary] table.  This assumes that all the nodes are
present and sorted according to specified ordering convention contained in \fIflags\fP.
If incoming data represents rows, make \fIflags\fP start with \fBT\fP(op) if first row is y = ymax
or \fBB\fP(ottom) if first row is y = ymin.  Then, append \fBL\fP or \fBR\fP to indicate that first element is at left
or right end of row.  Likewise for column formats: start with \fBL\fP or \fBR\fP to position first column,
and then append \fBT\fP or \fBB\fP to position first element in a row.  
For gridline registered grids:  If data are periodic in x but the
incoming data do not contain the (redundant) column at x = xmax, append \fBx\fP.  For data periodic in y
without redundant row at y = ymax, append \fBy\fP.  Append \fBs\fP\fIn\fP to skip the first \fIn\fP number
of bytes (probably a header).  If the byte-order needs to be swapped, append \fBw\fP.  Select
one of several data types (all binary except \fBa\fP):
.br
.sp
	\fBa\fP  ASCII representation
.br
	\fBc\fP  signed 1-byte character
.br
	\fBu\fP  unsigned 1-byte character
.br
	\fBh\fP  short 2-byte integer
.br
	\fBi\fP  4-byte integer
.br
	\fBl\fP  long (4- or 8-byte) integer
.br
	\fBf\fP  4-byte floating point single precision
.br
	\fBd\fP  8-byte floating point double precision
.br
.sp
Default format is scanline orientation of ASCII numbers: \fB\-ZTLa\fP.
Note that \fB\-Z\fP only applies to 1-column input.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 3 input columns].  This option only applies to xyz input files; see \fB\-Z\fP for z tables.
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To create a grdfile from the ASCII data in hawaii_grv.xyz, use
.br
.sp
\fBxyz2grd\fP hawaii_grv.xyz \fB\-D\fPdegree/degree/mGal/1/0/"Hawaiian Gravity"/"GRS-80 Ellipsoid used"
\fB\-G\fPhawaii_grv_new.grd \fB\-R\fP198/208/18/25 \fB\-I\fP5\fBm \-V\fP
.br
.sp
To create a grdfile from the raw binary (3-column, single-precision) scanline-oriented data raw.b, use
.br
.sp
\fBxyz2grd\fP raw.b \fB\-D\fPm/m/m/1/0/=/= \fB\-G\fPraw.grd \fB\-R\fP0/100/0/100 \fB\-I\fP1 \fB\-V \-Z \-b\fP3
.br
.sp
To make a grdfile from the raw binary USGS DEM (short integer) scanline-oriented data topo30. on the NGDC
global relief Data CD-ROM, with values of -9999 indicate missing data, one must on some machine reverse the byte-order.  On such machines (like Sun), use
.br
.sp
\fBxyz2grd\fP topo30. \fB\-D\fPm/m/m/1/0/=/= \fB\-G\fPustopo.grd \fB\-R\fP234/294/24/50 \fB\-I\fP30c \fB\-N\fP-9999 \fB\-V \-ZTLhw\fP
.br
.sp
Say you have received a binary file with 4-byte floating points that were
written on a machine of different byte-order than yours.  You can swap the
byte-order with
.br
.sp
\fBxyz2grd\fP floats.bin \fB\-S\fPnew_floats.bin \fB\-V \-Zf\fP
.SH "SEE ALSO"
.IR GMT (l),
.IR grd2xyz (l),
.IR grdedit (l)
