.TH MINMAX l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
minmax \- Find extreme values in data tables
.SH SYNOPSIS
\fBminmax\fP [ \fIfiles\fP] [ \fB\-C\fP ] [ \fB\-EL\fP|\fBl\fP|\fBH\fP|\fBh\fP\fIcol\fP ] 
[ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP\fIdx\fP[/\fIdy\fP[/\fIdz\fP...] ] 
[ \fB\-M\fP[\fIflag\fP] ] [ \fB\-T\fP\fIdz\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBminmax\fP reads its standard input [or from files] and finds the
extreme values in each of the columns.  It recognizes NaNs and
will print warnings if the number of columns vary from record to record.
As an option, \fBminmax\fP will find the extent of the first \fIn\fP columns rounded
up and down to the nearest multiple of the supplied increments.  By default, this output
will be in the form \fB\-R\fP\fIw/e/s/n\fP which can be used directly in the command line
for other programs (hence only \fIdx\fP and \fIdy\fP are neede), or the output will be in
column form for as many columns as there are increments provided.
A similar option (\fB\-T\fP) will provide a \fB\-T\fP\fIzmin/zmax/dz\fP string for makecpt.
.TP
\fIxyzfile\fP
ASCII [or binary, see \fB\-b\fP] file(s) holding a fixed number of data columns. 
.SH OPTIONS
.TP
.B \-C
Report the min/max values per column in separate columns [Default uses <min/max> format].
.TP
.B \-E
Returns the record whose column \fIcol\fP contains the minimum (\fBl\fP) or maximum (\fBh\fP)
value.  Upper case (\fBL|H\fP) works on absolute value of the data.  In case of multiple
matches, only the first record is returned.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Report the min/max of the first \fIn\fP columns to the nearest multiple of the provided
increments (separate the \fIn\fP increments by slashes), and output results in the form \fB\-R\fP\fIw/e/s/n\fP
(unless \fB\-C\fP is set).  If only one increment is given we also use it for the second
column (for backwards compatibility).  To override this behaviour, use \fB\-Ip\fB\fIdx\fP.
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-T
Report the min/max of the first column to the nearest multiple of \fIdz\fP and output this in
the form \fB\-T\fP\fIzmin/zmax/dz\fP.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
Only works when \fB\-I\fP is selected.
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
To find the extreme values in the file ship_gravity.xygd:
.br
.sp
\fBminmax\fP ship_gravity.xygd
.br
.sp
Output should look like
.br
.sp
ship_gravity.xygd: N = 6992 <326.125/334.684> <-28.0711/-8.6837> <-47.7/177.6> <0.6/3544.9>
.br
.sp
To find the extreme values in the file track.xy to the nearest 5 units and use this
region to draw a line using psxy, run
.br
.sp
\fBpsxy\fP `\fBminmax\fP \fB\-I\fP5 track.xy` track.xy \fB\-Jx\fP1 \fB\-B\fP5 \fB\-P\fP > track.ps
.br
.sp
To find the min and max values for each of the first 4 columns, but rounded to integers, use
.br
.sp
\fBminmax\fP junkfile \fB\-C \-I\fP1/1/1/1
.SH "SEE ALSO"
.IR GMT (l)
