.TH PSMECA l "1 Jan 2004"
.SH NAME
psmeca \fR\- Plot focal mechanisms on maps
.SH SYNOPSIS
.br
psmeca \fIfiles\fR \fB\-J\fIparameters \fB\-R\fIwest/east/south/north\fR
[ \fB\-B\fItickinfo\fR ] [ \fB\-C\fIpen\fR ] [ \fB\-D\fIdepmin/depmax\fR ]
[ \fB\-E\fIfill\fR] [ \fB\-G\fIfill\fR] [ \fB\-H\fR[n] ]
[ \fB\-K\fR ] [ \fB\-L\fI[pen]\fR ] [ \fB\-M\fR ] [ \fB\-N\fR ] [ \fB\-O\fR ]
[ \fB\-P\fR ]
[ \fB\-S\fI<symbol><scale>\fR[/d]] [ \fB\-T\fInum_of_plane\fR[<pen>] ]
[ \fB\-U\fI[label]\fR ] [ \fB\-V\fR ] [ \fB\-W\fIpen\fR ] [\fB\-X\fIx-shift\fR ]
[ \fB\-Y\fIy-shift\fR ] [\fB\-Z\fIcptfile\fR] [ \fB\-z\fR ]
[ \fB\-a\fI[<size>\fR[\fIP_symbol>\fR[\fIT_symbol\fR]]] ]
[ \fB\-g\fIfill\fR ] [\fB\-e\fIfill\fR ] [ \fB-o\fR ] [ \fB\-p\fIpen\fR ]
[ \fB\-t\fIpen\fR ] [ \fB\-:\fR] [\fB\-c\fIcopies\fR ]
.SH DESCRIPTION
.br
\fBpsmeca\fR reads data values from \fIfiles\fR [or standard input]
and generates \fIPostScript\fR code that will plot focal mechanisms
on a map. Most options are the same as for psxy.
The \fIPostScript\fR code is written to standard output.
.br
.sp
.SH ARGUMENTS
\fIfiles\fR
List one or more file-names. If no files are given, psvelomeca will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest. To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
\fB\-S\fR
Selects the meaning of the columns in the data file
.br
In order to use the same file to plot cross-sections, depth is in third column.
Nevertheless, it is possible to use "old style" psvelomeca input files
without depth in third column using the \fB-o\fR option.
.br
.TP
\fB\-Sa\fIscale[c/i][/fontsize[/offset[u]]]\fR
Focal mechanisms in Aki and Richard convention.
\fIscale\fR adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude. Scale is the size for
magnitude = 5 in inch (unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive
quadrants can be specified with the \fB-G\fR option. The color or shade
of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6\fR:
strike, dip and rake in degrees
.IP \fB7\fR:
magnitude
.IP \fB8,9\fR:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option. Using 0,0 in columns
8 and 9 will plot the beach ball at the longtiude, latitude given in
columns 1 and 2. The \fB-:\fR option will interchange the order of
columns (1,2) and (8,9).
.IP \fB10\fR:
Text string to appear above the beach ball (optional).
.br
.sp
.TP
\fB\-Sc\fIscale[c/i][/fontsize[/offset[u]]]\fR
Focal mechanisms in Harvard CMT convention.
\fIscale\fR adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude. Scale is the size for
magnitude = 5 (that is M0 = 4.0E23 dynes-cm)
in inch (unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option. The color or shade
of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6\fR:
strike, dip, and rake of plane 1
.IP \fB7,8,9\fR:
strike, dip, and rake of plane 2
.IP \fB10,11\fR:
mantissa and exponent of moment in dyne-cm
.IP \fB12,13\fR:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option. Using (0,0) in
columns 11 and 12 will plot the beach ball at the longitude, latitude
given in columns 1 and 2. The \fB-:\fR option will interchange the order of
columns (1,2) and (12,13).
.IP \fB14\fR:
Text string to appear above the beach ball (optional).
.TP
\fB\-Sm\fIscale[c/i][/fontsize[/offset[u]]]\fR
Seismic moment tensor (Harvard CMT, with zero trace). \fIscale\fR adjusts the
scaling of the radius of the "beach ball", which will be proportional
to the magnitude. Scale is the size for magnitude = 5 (that is scalar seismic
moment = 4.0E23 dynes-cm)
in inch (unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
(\fB-T\fI0\fR option overlays best double couple transparently.)
Put \fB\-Sd\fIscale[/fontsize[/offset[u]]]\fR to plot the only double couple part of moment tensor.
Put \fB\-Sz\fIscale[/fontsize[/offset[u]]]\fR to plot anisotropic part of moment tensor (zero trace).
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option. The color or shade
of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6,7,8,9\fR:
mrr, mtt, mff, mrt, mrf, mtf in 10*exponent dynes-cm
.IP \fB10\fR:
exponent
.IP \fB11,12\fR:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option. Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2. The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.IP \fB13\fR:
Text string to appear above the beach ball (optional).
.br
.sp
.TP
\fB\-Sp\fIscale[c/i][/fontsize[/offset[u]]]\fR
Focal mechanisms given with partial data on both planes.
\fIscale\fR adjusts the scaling of the radius of the "beach
ball", which will be proportional to the magnitude. Scale is the size
for magnitude = 5 in inch (unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option. The color or shade
of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5\fR:
strike, dip of plane 1
.IP \fB6\fR:
strike of plane 2
.IP \fB7\fR:
must be -1/+1 for a normal/inverse fault
.IP \fB8\fR:
magnitude
.IP \fB9,10\fR:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option. Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2. The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.IP \fB11\fR:
Text string to appear above the beach ball (optional).
.br
.sp
.TP
\fB\-Sx\fIscale[c/i][/fontsize[/offset[u]]]\fR Principal axis.
\fIscale\fR adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. Scale is the size for magnitude = 5 (that is
seismic scalar moment = 4*10e+23 dynes-cm)
in inch (unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
(\fB-T\fI0\fR option overlays best double couple transparently.)
Put \fB\-Sy\fIscale[c/i][/fontsize[/offset[u]]]\fR to plot the only double couple part of
moment tensor.
Put \fB\-St\fIscale[c/i][/fontsize[/offset[u]]]\fR to plot zero trace moment tensor.
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option. The color or shade
of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6,7,8,9,10,11,12\fR:
value (in 10*exponent dynes-cm), azimuth, plunge of T, N, P axis.
.IP \fB13\fR:
exponent
.IP \fB14,15\fR:
longtiude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option. Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2. The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.IP \fB16\fR:
Text string to appear above the beach ball (optional).
.br
.sp
.LP
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
\fB\-C\fR[\fIpen\fR][P\fIpointsize\fR]
Offsets focal mechanisms to the longitude, latitude specified in the last
two columns of the input file before the (optional) text string. A small
circle is plotted at the initial location and a line connects the beachball
to the circle. Specify \fIpen\fR and/or P\fIpointsize\fR to change the line
style and/or size of the circle. [Defaults: \fIpen\fR width = 1, color = 0/0/0,
texture = solid; \fIpointsize\fR 0].
.br
.TP
\fB\-D
\fIdepmin/depmax\fR
Plots events between depmin and depmax.
.br
.TP
\fB\-E\fR\fIfill\fR
Selects filling of extensive quadrants. Usually white.
Set the shade (0\-255) or color (r/g/b) [Default is 255/255/255].
.br
.TP
\fB\-G\fR\fIfill\fR
Selects filling of focal mechanisms. By
convention, the compressional quadrants of the focal mechanism beach
balls are shaded. Set the shade (0\-255) or color (r/g/b) [Default is
0/0/0].
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults file. If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
\fB\-L\fR[\fIpen\fR]
Draws the "beach ball" outline with \fIpen\fR attributes.
[Defaults width = 1, color = 0/0/0, texture = solid].
.br
.TP
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside frame boundary specified by
\fB\-R\fR [Default plots symbols inside frame only].
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
\fB\-T\fR[\fInum_of_planes\fR]
\fRPlots the nodal planes and outlines the bubble which is transparent.
If \fInum_of_planes\fR is
.br
      \fI0\fR: both nodal planes are plotted;
      \fI1\fR: only the first nodal plane is plotted;
      \fI2\fR: only the second nodal plane is plotted.
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The GMT parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
\fB\-W
\fRSet default pen attributes.
 [Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
\fB\-Z\fIcptfile
\fRGive a color palette file and let compressive part color be determined by the z-value in the
third column.
.br
.TP
\fB\-z
\fROverlay zero trace moment tensor.
.br
.TP
\fB\-a\fR[\fIsize\fR/[\fIP_axis_symbol\fR/[\fIT_axis_symbol\fR]]]
Computes and plots P and T axes with symbols. Optionally specify \fIsize\fR
and (separate) P and T axis symbols from the following:
(\fBc\fR) circle, (\fBd\fR) diamond, (\fBh\fR) hexagon,
(\fBi\fR) inverse triangle,
(\fBp\fR)point, (\fBs\fR) square, (\fBt\fR) triangle,
(\fBx\fR) cross. [Defaults: \fI0.2\fBc\fI/c/c\fR or \fI0.08\fBi/\fIc/c\fR.]
.br
.TP
\fB\-e\fR\fIfill\fR
\fRSelects filling of T axis symbol.
Set the shade (0\-255) or color (r/g/b). Default is white.
.br
.TP
\fB\-g\fR\fIfill\fR
Selects filling of P axis symbol.
Set the shade (0\-255) or color (r/g/b). Default black.
.br
.TP
\fB-o\fR
Use the psvelomeca input format without depth in the third column.
.br
.TP
\fB\-p\fR[\fIpen\fR]
Draws the P axis outline using default pen (see \fB\-W\fR), or sets
pen attributes.
.br
.TP
\fB\-t\fR[\fIpen\fR]
Draws the T axis outline using default pen (see \fB\-W\fR), or sets
pen attributes.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output. [Default is (longitude,latitude)].
Applies to geographic coordinates only.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
.sp
The following file should give a normal-faulting CMT mechanism:
.br
psmeca << END -R239/240/34/35.2 -Jm4 \.br
-Sc0.4 -H1 >! test.ps
.br
lon lat depth str dip slip st dip slip mant exp plon plat
.br
239.384 34.556 12. 180 18 -88 0 72 -90 5.5 0 0 0
.br
END
.br
.sp
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR psbasemap (GMTMANSECTION)
.IR psxy (GMTMANSECTION)
.SH REFERENCES
.br
\fRBomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismology, Freeman, 1980.
.br
F. A. Dahlen and Jeoren Trom, Theoretical Seismology, Princeton, 1998, p.167.
.br
Cliff Frohlich, Cliff'Nodes Concerning Plotting Nodal Lines for P, Sh and Sv'
.br
Seismological Research Letters, Volume 67, Number 1, January-February, 1996
.br
Thorne Lay, Terry C. Wallace, Modern Global Seismology, Academic Press, 1995, p.384.
.br
W.H. Press, S.A. Teukolsky, W.T. Vetterling, B.P. Flannery, Numerical Recipes in
 C, Cambridge University press (routine jacobi)
.SH AUTHORS
\fRGenevieve Patau
.br
CNRS UMR 7580
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@.ipgp.jussieu.fr)
