// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#include <string.h>
#include <stdlib.h>

#include "defines.h"
#include "structs.h"
#include "globals.h"

short
compressVoice (short lastVoice, short position, int notesPerTrack,
		int skip, short firstVoice = 0)
{
  int voice;

  for (voice = (int)firstVoice; voice < lastVoice; voice++)
    {
      if (voice == position)
	{
	  voice += (skip - 1);
	}
      else if ((patternTable[voice] != NULL) &&
	       !bcmp (patternTable[voice],
		      patternTable[position], sizeof (struct noteInfo) *
		      notesPerTrack))
	{
	  free (patternTable[position]);
	  patternTable[position] = NULL;
	  return voice;
	}
    }

  return position;
}
