/* $Id: draw.h,v 1.6 2000/01/13 20:11:22 mac Exp $ */

/*
 * glbiff -- A Mesa/OpenGL-based `xbiff' substitute
 * Copyright (C) 2000  Maciej Kalisiak
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <X11/Xlib.h>

////// prototypes
void redraw(Display *dpy, Window w);
void draw_land();
void draw_post();
void draw_mbox_top();
void draw_mbox_side( float nx, float ny, float nz );
void draw_mbox_door();
void draw_mbox_flag();
void draw_mbox();
void make_check_image(void);


////// constants
const float SIDE_HEIGHT=0.3;
const int DOME_SEGS=10;
const float FLAG_SCALE=1.0/1.5;

const int MAX_MAIL_DRAWABLE=100;	// maximum # of email that will fit
				// (when drawn)
const int LAND_WIDTH=20;		// how big the "land" square should be

const int check_image_w = 64;
const int check_image_h = 64;

////// some globals
extern bool fDoorOpen;
extern bool fLookHeadOn;
extern GLubyte check_image[check_image_h][check_image_w][4];
extern GLuint texName;
