/* $Id: astro.h,v 1.5 2000/01/13 20:11:22 mac Exp $ */

/*
 * glbiff -- A Mesa/OpenGL-based `xbiff' substitute
 * Copyright (C) 2000  Maciej Kalisiak
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __ASTRO_H__
#define __ASTRO_H__

#include <math.h>

typedef unsigned char uchar;

typedef double julian_day;
const int INVALID_JD = -1;

const double TimeZone = -5;

const int JAN=1;
const int FEB=2;
const int MAR=3;
const int APR=4;
const int MAY=5;
const int JUN=6;
const int JUL=7;
const int AUG=8;
const int SEP=9;
const int OCT=10;
const int NOV=11;
const int DEC=12;


////////////////////////////////////////////////////////////
// class date
//
// NOTE: `month' ranges from 1 to 12
//       `day' ranges from 1 to {29,30,31}, depending on month
////////////////////////////////////////////////////////////
class Date {
public:
  int year;
  uchar month;
  double day;

  Date():
    year(1990), month(1), day(1) {}
  Date( int y, uchar m, double d ):
    year(y), month(m), day(d) {}
  
  bool operator>( const Date & ) const;
  bool operator<( const Date & ) const;
  bool operator==( const Date & dt ) const {
    if( year==dt.year && month==dt.month && day==dt.day )
      return true;
    return false;
  }
  bool operator>=( const Date & dt ) const {
    if( *this > dt || *this == dt )
      return true;
    return false;
  }

  bool valid();
};

#if 0
inline
bool operator>( const Date& d1, const Date& d2 ) {
  return d1.operator>( d2 );
}
inline
bool operator<( const Date& d1, const Date& d2 ) {
  return d1.operator<( d2 );
}
#endif

///// NOTE: all angles will be kept internally (in struct) in radian form
struct coord {
  // for equatorial coords: a == RA, b == declination
  // for ecliptic coords: a == lambda, b == beta
  // for geographical coords: a == longitude, b == latitude; W is positive
  // for sunrise/sunset:      a == sunrise, b == sunset
  double a, b;

  coord():
    a(0), b(0) {}
  coord(double c, double d):
    a(c), b(d) {}
};

struct time_hms {
  unsigned h;		// hour
  unsigned m;		// mins
  unsigned s;		// secs
};
  
//////////////////////////// prototypes ////////////////////////////////
coord sun_rise_set( Date dt, coord geo );
time_hms time_convert( double decimal_hour );

void astro_test(void);	// call this to run the astro test

//////////////////////////// constants ////////////////////////////////
const double SOLAR_D_PER_Y = 365.242191;	// solar days per year

//// these are all relative to epoch 1990.0
const double EPSILON_G = 279.403303;	// ecliptic longitude
const double OMEGA_G = 282.768422;	// ecliptic longitude at perigee
const double E = 0.016713;		// eccentricity of orbit
const double R_O = 1.495985e+8;		// semi-major axis
const double THETA_O = 0.533128;	// angular diam. at r_o in degrees

#endif /* __ASTRO_H__ */
