/* $Header: /cvs/gnome/gIDE/src/gI_text.h,v 1.1 1999/12/05 07:17:51 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_TEXT_H
#define GI_TEXT_H

#include <config.h>
#include <gnome.h>

/*
 * Prototypes for 'gI_text.c'
 */

/*** Wrapper defines around gtk_text_* and gtk_sctext_* functions ***/
#ifdef HAVE_GTKTEXT_PATCH
        #define gI_text_set_editable(a,b)       gtk_sctext_set_editable(GTK_SCTEXT(a),b)
        #define gI_text_set_word_wrap(a,b)      gtk_sctext_set_word_wrap(GTK_SCTEXT(a),b)
        #define gI_text_set_line_wrap(a,b)      gtk_sctext_set_line_wrap(GTK_SCTEXT(a),b)
        #define gI_text_set_adjustments(a,b,c)  gtk_sctext_set_adjustments(GTK_SCTEXT(a),b,c)
        #define gI_text_set_point(a,b)          gtk_sctext_set_point(GTK_SCTEXT(a),b)
        #define gI_text_get_point(a)            gtk_sctext_get_point(GTK_SCTEXT(a))
        #define gI_text_get_length(a)           gtk_sctext_get_length(GTK_SCTEXT(a))
        #define gI_text_freeze(a)               gtk_sctext_freeze(GTK_SCTEXT(a))
        #define gI_text_thaw(a)                 gtk_sctext_thaw(GTK_SCTEXT(a))
        #define gI_text_insert(a,b,c,d,e,f)     gtk_sctext_insert(GTK_SCTEXT(a),b,c,d,e,f)
        #define gI_text_backward_delete(a,b)    gtk_sctext_backward_delete(GTK_SCTEXT(a),b)
        #define gI_text_forward_delete(a,b)     gtk_sctext_forward_delete(GTK_SCTEXT(a),b)
	#define gI_text_default_tab_width(a)  GTK_SCTEXT(a)->default_tab_width
	#define gI_text_tab_stops(a)  GTK_SCTEXT(a)->tab_stops
	#define gI_text_vadj(a)  GTK_SCTEXT(a)->vadj
	#define gI_text_cursor_pos_x(a)  GTK_SCTEXT(a)->cursor_pos_x
	#define gI_text_cursor_pos_y(a)  GTK_SCTEXT(a)->cursor_pos_y
	#define gI_text_last_ver_value(a)  GTK_SCTEXT(a)->last_ver_value
#else
        #define gI_text_set_editable(a,b)       gtk_text_set_editable(GTK_TEXT(a),b)
        #define gI_text_set_word_wrap(a,b)      gtk_text_set_word_wrap(GTK_TEXT(a),b)
        #define gI_text_set_line_wrap(a,b)      gtk_text_set_line_wrap(GTK_TEXT(a),b)
        #define gI_text_set_adjustments(a,b,c)  gtk_text_set_adjustments(GTK_TEXT(a),b,c)
        #define gI_text_set_point(a,b)          gtk_text_set_point(GTK_TEXT(a),b)
        #define gI_text_get_point(a)            gtk_text_get_point(GTK_TEXT(a))
        #define gI_text_get_length(a)           gtk_text_get_length(GTK_TEXT(a))
        #define gI_text_freeze(a)               gtk_text_freeze(GTK_TEXT(a))
        #define gI_text_thaw(a)                 gtk_text_thaw(GTK_TEXT(a))
        #define gI_text_insert(a,b,c,d,e,f)     gtk_text_insert(GTK_TEXT(a),b,c,d,e,f)
        #define gI_text_backward_delete(a,b)    gtk_text_backward_delete(GTK_TEXT(a),b)
        #define gI_text_forward_delete(a,b)     gtk_text_forward_delete(GTK_TEXT(a),b)
	#define gI_text_default_tab_width(a)  GTK_TEXT(a)->default_tab_width
	#define gI_text_tab_stops(a)  GTK_TEXT(a)->tab_stops
	#define gI_text_vadj(a)  GTK_TEXT(a)->vadj
	#define gI_text_cursor_pos_x(a)  GTK_TEXT(a)->cursor_pos_x
	#define gI_text_cursor_pos_y(a)  GTK_TEXT(a)->cursor_pos_y
	#define gI_text_last_ver_value(a)  GTK_TEXT(a)->last_ver_value
#endif

#endif

