/* $Header: /cvs/gnome/gIDE/src/gI_search.h,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_SEARCH_H
#define GI_SEARCH_H

#include <gtk/gtk.h>

/*
 * Prototypes for 'gI_search.c'
 */
void search_goto_line( GtkWidget *widget, gpointer data );
void search_search( GtkWidget *widget, gpointer data );
void search_again( GtkWidget *widget, gpointer data );
void search_replace( GtkWidget *widget, gpointer data );
void __goto_point( gint point );
void history_add_to_history(GList *,GtkCombo *);
void history_add_to_combo(GList *,GtkCombo *);
void find_in_files( GtkWidget *widget, gpointer data );

typedef struct _gI_FiF_Window gI_FiF_Window;
struct _gI_FiF_Window
{
	GtkWidget *window;
	GtkWidget *text;
	GtkWidget *dir;
	GtkWidget *pat;
	GtkWidget *casein;
	GtkWidget *regexp;
	GtkWidget *recursive;
};

gI_FiF_Window *gI_FiF_Window_new();
void gI_FiF_Window_destroy( GtkWidget *widget, gI_FiF_Window *win );

void replace_in_files( GtkWidget *widget, gpointer data );

typedef struct _gI_RiF_Window gI_RiF_Window;
struct _gI_RiF_Window
{
	GtkWidget *window;
	GtkWidget *text;
	GtkWidget *repltext;
	GtkWidget *dir;
	GtkWidget *pat;
	GtkWidget *casein;
	GtkWidget *regexp;
	GtkWidget *recursive;
};

gI_RiF_Window *gI_RiF_Window_new();
void gI_RiF_Window_destroy( GtkWidget *widget, gI_RiF_Window *win );

#endif

