/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  statusbarsignals.cc - Gtk::Statusbar virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "statusbar.hh"
#include "statusbarsignals.hh"
#include "private/statusbarclass.hh"

using namespace GFC;

/*  Gtk::StatusbarSignals
 */

Gtk::StatusbarSignals::StatusbarSignals(Statusbar *statusbar)
: ContainerSignals(statusbar)
{
	Gtk::StatusbarClass::init(GTK_STATUSBAR_GET_CLASS(statusbar->gtk_statusbar()));
}

Gtk::StatusbarSignals::~StatusbarSignals()
{
}

void
Gtk::StatusbarSignals::on_text_pushed(unsigned int context_id, const String& text)
{
	GtkStatusbarClass *g_class = StatusbarClass::get_parent_class(instance_);
	if (g_class->text_pushed)
		g_class->text_pushed((GtkStatusbar*)instance_, context_id, text.c_str());
}

void
Gtk::StatusbarSignals::on_text_popped(unsigned int context_id, const String& text)
{
	GtkStatusbarClass *g_class = StatusbarClass::get_parent_class(instance_);
	if (g_class->text_popped)
		g_class->text_popped((GtkStatusbar*)instance_, context_id, text.c_str());
}

/*  Gtk::StatusbarClass
 */

void
Gtk::StatusbarClass::init(GtkStatusbarClass *g_class)
{
	g_class->text_pushed = &text_pushed_proxy;
	g_class->text_popped = &text_popped_proxy;
}

GtkStatusbarClass*
Gtk::StatusbarClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_STATUSBAR_GET_CLASS(instance));
	return static_cast<GtkStatusbarClass*>(ptr);
}

GType
Gtk::StatusbarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_STATUSBAR);
	}
	return type;
}

void*
Gtk::StatusbarClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::StatusbarClass::text_pushed_proxy(GtkStatusbar *statusbar, guint context_id, const gchar *text)
{
	void *ptr = g_object_get_qdata((GObject*)statusbar, G::ObjectSignals::quark());
	if (ptr)
	{
		String tmp_text(text);
		static_cast<StatusbarSignals*>(ptr)->on_text_pushed(context_id, tmp_text);
	}
	else
	{
		GtkStatusbarClass *g_class = StatusbarClass::get_parent_class(statusbar);
		if (g_class->text_pushed)
			g_class->text_pushed(statusbar, context_id, text);
	}
}

void
Gtk::StatusbarClass::text_popped_proxy(GtkStatusbar *statusbar, guint context_id, const gchar *text)
{
	void *ptr = g_object_get_qdata((GObject*)statusbar, G::ObjectSignals::quark());
	if (ptr)
	{
		String tmp_text(text);
		static_cast<StatusbarSignals*>(ptr)->on_text_popped(context_id, tmp_text);
	}
	else
	{
		GtkStatusbarClass *g_class = StatusbarClass::get_parent_class(statusbar);
		if (g_class->text_popped)
			g_class->text_popped(statusbar, context_id, text);
	}
}

