/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  cellrenderertextsignals.cc - Gtk::CellRendererText virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "cellrenderertext.hh"
#include "cellrenderertextsignals.hh"
#include "private/cellrenderertextclass.hh"

using namespace GFC;

/*  Gtk::CellRendererTextSignals
 */

Gtk::CellRendererTextSignals::CellRendererTextSignals(CellRendererText *cell)
: CellRendererSignals(cell)
{
	Gtk::CellRendererTextClass::init(GTK_CELL_RENDERER_TEXT_GET_CLASS(cell->gtk_cell_renderer_text()));
}

Gtk::CellRendererTextSignals::~CellRendererTextSignals()
{
}

void
Gtk::CellRendererTextSignals::on_edited(const String& path, const String& new_text)
{
	GtkCellRendererTextClass *g_class = CellRendererTextClass::get_parent_class(instance_);
	if (g_class->edited)
		g_class->edited((GtkCellRendererText*)instance_, path.c_str(), new_text.c_str());
}

/*  Gtk::CellRendererTextClass
 */

void
Gtk::CellRendererTextClass::init(GtkCellRendererTextClass *g_class)
{
	g_class->edited = &edited_proxy;
}

GtkCellRendererTextClass*
Gtk::CellRendererTextClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_CELL_RENDERER_TEXT_GET_CLASS(instance));
	return static_cast<GtkCellRendererTextClass*>(ptr);
}

GType
Gtk::CellRendererTextClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CELL_RENDERER_TEXT);
	}
	return type;
}

void*
Gtk::CellRendererTextClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CellRendererTextClass::edited_proxy(GtkCellRendererText *cell_renderer_text, const gchar *path, const gchar *new_text)
{
	void *ptr = g_object_get_qdata((GObject*)cell_renderer_text, G::ObjectSignals::quark());
	if (ptr)
	{
		String tmp_path(path);
		String tmp_new_text(new_text);
		static_cast<CellRendererTextSignals*>(ptr)->on_edited(tmp_path, tmp_new_text);
	}
	else
	{
		GtkCellRendererTextClass *g_class = CellRendererTextClass::get_parent_class(cell_renderer_text);
		if (g_class->edited)
			g_class->edited(cell_renderer_text, path, new_text);
	}
}

