/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  region.inl - Gdk::Region inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GdkRegion*
GFC::Gdk::Region::gdk_region() const
{
	return region_;
}

inline GFC::Gdk::Region::operator GdkRegion* () const
{
	return this ? region_ : 0;
}

inline bool
GFC::Gdk::Region::empty() const
{
	return gdk_region_empty(region_);
}

inline bool
GFC::Gdk::Region::point_in(int x, int y) const
{
	return gdk_region_point_in(region_, x, y);
}

inline void
GFC::Gdk::Region::offset(int dx, int dy)
{
	gdk_region_offset(region_, dx, dy);
}

inline void
GFC::Gdk::Region::shrink(int dx, int dy)
{
	gdk_region_shrink(region_, dx, dy);
}

