#!/bin/sh

if [ ! -x /usr/bin/unzip ]; then
	echo "You need the unzip package, to run this script."
	exit 1
fi

V4="http://geolite.maxmind.com/download/geoip/database/GeoIPCountryCSV.zip"
V6="http://geolite.maxmind.com/download/geoip/database/GeoIPv6.csv.gz"

OLDDIR=$(pwd)
TMPDIR=$(mktemp -d)
DATE=$(date +'%Y%m%d')

cd ${TMPDIR}

wget ${V4} -O v4.csv.zip
wget ${V6} -O v6.csv.gz

gunzip v6.csv.gz
unzip v4.csv.zip

mkdir ${TMPDIR}/geoip-database-${DATE}

mv GeoIPCountryWhois.csv ${TMPDIR}/geoip-database-${DATE}/
mv v6.csv ${TMPDIR}/geoip-database-${DATE}/

tar -cjf geoip-database_${DATE}.orig.tar.bz2 geoip-database-${DATE}
mv geoip-database_${DATE}.orig.tar.bz2 ${OLDDIR}/../geoip-database_${DATE}.orig.tar.bz2

cd ${OLDDIR}
rm -rf ${TMPDIR}

echo "Saved tarball: ${OLDDIR}/../geoip-database_${DATE}.orig.tar.bz2"

exit 0
