/*
** $Id: shell_func_ext.h,v 1.10 2001/06/29 21:24:17 mhucka Exp $
** $Log: shell_func_ext.h,v $
** Revision 1.10  2001/06/29 21:24:17  mhucka
** Lots of additions, and a reorganization.
**
** Revision 1.9  2001/04/25 17:17:00  mhucka
** Misc. small changes to improve portability and address compiler warnings.
**
** Revision 1.8  2000/09/21 19:38:20  mhucka
** Added declarations for a few more functions.
**
** Revision 1.7  2000/09/07 05:15:58  mhucka
** Added declaration for Autoshell() and new function SetAutoShell().
**
** Revision 1.6  2000/05/19 18:40:05  mhucka
** Added declaration for SearchForNonScript.
**
** Revision 1.5  2000/03/27 10:33:07  mhucka
** Commented out statusline functionality, because it caused GENESIS to send
** control character sequences upon exit and thereby screw up the user's
** terminal.  Also added return type declarations for various things.
**
** Revision 1.4  1999/08/22 04:42:15  mhucka
** Various fixes, mostly for Red Hat Linux 6.0
**
** Revision 1.3  1995/02/22 19:12:58  dhb
** Added GetHistory() extern statement.
**
** Revision 1.2  1994/04/14  16:22:29  dhb
** Added PFI GetFuncAddress() to extern declarations.
**
** Revision 1.1  1992/12/11  19:04:53  dhb
** Initial revision
**
*/

#ifndef SHELL_FUNC_EXT_H
#define SHELL_FUNC_EXT_H

#include <stdlib.h>
#include <string.h>
#include "result.h"
#include "shell_struct.h"

/*
** PFI is defined in header.h, but some places where PFI is needed can't
** include header.h without a lot of trouble.  So, define it here if needed.
*/
#ifndef PFI_DEFINED
#define PFI_DEFINED
typedef int	(*PFI)();
#endif

extern int      AddCleanup();
extern void     AddFunc();
extern int      AddHistory();
extern int      AddJob();
extern int      AddScript();
extern int      AlternatePrompt();
extern char    *ArgListToString();
extern double   Atod();
extern float    Atof();
extern int      Autoshell();
extern int      AuxFuncIndex();
extern int      AvailableCharacters();
extern int      cleareol();
extern int      ClearScriptStack();
extern int      CloseLog();
extern char   **CopyArgv();
extern char    *CopyString();
extern Script  *CurrentScript();
extern FILE    *CurrentScriptFp();
extern int      CurrentScriptLine();
extern int      CurrentScriptLine();
extern char    *CurrentScriptName();
extern int      DefaultPrompt();
extern int      DisableStatusLine();
extern void     do_add_func();
extern void     do_autoshell();
extern int      do_cd();
extern int      do_debug();
extern int      do_debug_func();
extern void     do_echo();
extern void     do_execute();
extern void     do_exit();
extern char    *do_getenv();
extern void     do_getinfo();
extern void     do_load_func();
extern void     do_load_lib();
extern int      do_logoff();
extern int      do_mkdir();
extern void     do_printargs();
extern void     do_printenv();
extern void     do_return();
extern void     do_return();
extern void     do_setenv();
extern void     do_set_prompt();
extern void     do_shell();
extern int      do_silent();
extern void     do_source();
extern int      do_status_message();
extern void     do_where();
extern int      Dynamic();
extern int      EmptyLine();
extern int      EmptyString();
extern int      EnableDynamicLoad();
extern int      EnableHistory();
extern int      EnableScrollRegion();
extern int      EnableStatusLine();
extern void     EndScript();
extern void     EndScript();
extern void     Error();
extern int      ExecuteCleanups();
extern Result   ExecuteCommand();
extern int      ExecuteJobs();
extern void     FreeArgv();
extern void     FreeArgv();
extern void     FreeString();
extern char    *ftoa();
extern int      FuncIndex();
extern int      genesis_tty();
extern char    *getenv();
extern PFI      GetFuncAddress();
extern char    *GetFuncName();
extern char*    GetHistory();
extern int      GetInfo();
extern int      GetLine();
extern char    *GetLineFp();
extern int      HashFunc();
extern void     HashInit();
extern char    *History();
extern int      HistoryCnt();
extern int      IncludeScript();
extern int      inc_prompt();
extern void     InitJobs();
extern int      Interpreter();
extern int      is_alpha();
extern int      is_alphanum();
extern int      IsBatchMode();
extern int      IsBatchMode();
extern int      IsCommand();
extern int      is_data_char();
extern int      is_eol_char();
extern int      IsFile();
extern int      IsHistoryEnabled();
extern int      IsInclude();
extern int      is_index_delimiter();
extern int      is_num();
extern int      IsSilent();
extern int      is_space_char();
extern int      is_str_delimiter();
extern int      IsStringDelimiter();
extern int      IsStringEnd();
extern int      is_str_var_delimiter();
extern int      IsTtyMode();
extern int      is_var_char();
extern int      IsWhiteSpace();
extern char    *itoa();
extern int      LoadFuncInit();
extern int      LogHeader();
extern int      LogTime();
extern int      LogTrailer();
extern int      lprintf();
extern int      lprint_only();
extern int      NestedLevel();
extern Script  *NextScript();
extern Script  *NextScript();
extern int      normal_tty();
extern char   **NULLArgv();
extern int      OpenLog();
extern FILE    *OpenScriptFile();
extern int      ParseInit();
extern int      ProcessStatus();
extern int      PutAuxFunc();
extern float    rangauss();
extern void     ReallocateArgList();
extern int      RecordStartTime();
extern int      RemoveCleanup();
extern int      RemoveJob();
extern void     ResetErrors();
extern int      RestoreCursorPosition();
extern int      restore_tty();
extern int      SaneTerm();
extern int      SaveCursorPosition();
extern int      ScriptArgc();
extern char    *ScriptArgv();
extern int      ScriptDepth();
extern int      ScriptEnded();
extern int      ScrollRegion();
extern FILE    *SearchForExecutable();
extern FILE    *SearchForNonScript();
extern FILE    *SearchForScript();
extern void     SetAutoshell();
extern void     SetBatchMode();
extern int      SetDefaultPrompt();
extern int      SetPrompt();
extern int      SetScript();
extern int      SetSilent(); 
extern void     SetTtyMode();
extern int      SetUpFuncTable();
extern int      SetupInterp();
extern char    *sgets();
extern void     ShowFuncNames();
extern void     ShowHistory();
extern int      show_prompt();
extern int      Sleep();
extern int      Standout();
extern int      StatusActive();
extern void     StringToArgList();
extern char    *StripCR();
extern int      TermGoto();
extern int      terminal_setup();
extern int      TermParse();
extern char    *termstr();
extern int      TraceScript();
extern void     tset();
extern int      ValidScript();
extern void     Warning();

/* 1999-07-16 <mhucka@bbb.caltech.edu>
 * This fix for Red Hat Linux 6.0 is courtesy of Mike Vanier
 * <mvanier@bbb.caltech.edu>.  
 */
#ifdef linux
extern char     *strchr __P ((__const char *__s, int __c));
#else
extern char	*strchr();
#endif


#endif /* SHELL_FUNC_EXT_H */
