/* $Id: Error.c,v 1.2 2000/06/12 04:28:20 mhucka Exp $ */
/*
 * $Log: Error.c,v $
 * Revision 1.2  2000/06/12 04:28:20  mhucka
 * Removed nested comments within header, to make compilers happy.
 *
 * Revision 1.1  1994/01/13 18:34:14  bhalla
 * Initial revision
 * */

#include <varargs.h>
#include <stdio.h>

void _XgPrintToStderr ();

static void (*error_handler)() = _XgPrintToStderr;


void XgError (format, va_alist)
     char *format;
     va_dcl
{
  char error[256];
  va_list args;

  va_start(args);
  vsprintf (error, format, args);
  va_end(args);
  
  (*error_handler) (error);
}


void _XgPrintToStderr (error) 
     char *error;
{
  fprintf (stderr, "Xodus: %s\n", error);
}

