/**********************************************************************
** This program is part of the kinetics library and is
**           copyright (C) 1995 Upinder S. Bhalla.
** It is made available under the terms of the
**           GNU Library General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
static char rcsid[] = "$Id: reac.c,v 1.1 1997/07/24 17:49:40 dhb Exp $";
 
/* $Log: reac.c,v $
 * Revision 1.1  1997/07/24 17:49:40  dhb
 * Initial revision
 *
 * Revision 1.2  1994/08/05  19:24:43  bhalla
 * Minor changes due to conversion to using n rather than conc
 *
 * Revision 1.1  1994/06/13  22:55:39  bhalla
 * Initial revision
 * */

#include "kin_ext.h"

/*
** A reaction handling element. does the basic forward/backward
** rate const management, must be used in conjunction with pools.
** Can handle any number of substrate or product components, but
** the reaction is only a single stage
*/


ReacFunc(reac,action)
register struct reac_type *reac;
Action		*action;
{
MsgIn	*msg;
double	substrate_prd;
double	product_prd;
double	dt;
int is_subst;
int is_prd;

    if(debug > 1){
		ActionHeader("ReactionPool",reac,action);
    }

    SELECT_ACTION(action){
		case INIT:
			break;
    	case PROCESS:
					substrate_prd = reac->kf;
					product_prd = reac->kb;
	
        			MSGLOOP(reac,msg) {
            			case 0:		/* TYPE = SUBSTRATE. */
								/* msg 0 = # of sub. Used to be Co */
							substrate_prd *= MSGVALUE(msg,0);
        				break;
						case 1:		/* TYPE = PRODUCT */
								/* msg 0 = # of prd. Used to be Co */
							product_prd *= MSGVALUE(msg,0);
						break;
						case 2:		/* TYPE = KF */
									/* msg 0 = kf */
							reac->kf = MSGVALUE(msg,0);
						break;
						case 3:		/* TYPE = KB */
									/* msg 0 = kb */
							reac->kb = MSGVALUE(msg,0);
						break;
        			}
					if (reac->is_active) {
						reac->A = product_prd;
						reac->B = substrate_prd;
					} else {
						reac->A = reac->B = 0;
					}
			break;
    	case RESET:
			is_subst = 0;
			is_prd = 0;
        		MSGLOOP(reac,msg) {
						case 0:
							is_subst = 1;
							break;
						case 1:
							is_prd = 1;
							break;
						case 2:		/* TYPE = KF */
									/* msg 0 = kf */
							reac->kf = MSGVALUE(msg,0);
						break;
						case 3:		/* TYPE = KB */
									/* msg 0 = kb */
							reac->kb = MSGVALUE(msg,0);
						break;
        		}
				reac->is_active = (is_subst && is_prd);
        	break;
    	case SET :
        	return(0); /* do the normal set */
			break;
	}
}
