/**********************************************************************
** This program is part of the kinetics library and is
**           copyright (C) 1995 Upinder S. Bhalla.
** It is made available under the terms of the
**           GNU Library General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
static char rcsid[] = "$Id: enz.c,v 1.1 1997/07/24 17:49:40 dhb Exp $";

/* $Log: enz.c,v $
 * Revision 1.1  1997/07/24 17:49:40  dhb
 * Initial revision
 *
 * Revision 1.3  1994/11/07  22:04:49  bhalla
 * Fixed bug with calculating nComplex and nComplexInt when Co was changed
 *
 * Revision 1.2  1994/08/05  19:23:06  bhalla
 * Conversion to using n rather than conc.
 *
 * Revision 1.1  1994/06/13  22:55:39  bhalla
 * Initial revision
 * */

#include "kin_ext.h"

/*
** enz handles 2 kinds of incoming and 3 outgoing msgs: from
**	substrate, product and enzyme pools. nComplex is stored locally
**		ksum = k2 + k3
*/

EnzFunc(enz,action)
register struct enz_type *enz;
Action		*action;
{
MsgIn	*msg;
double	mm_substrate_prd;
double	CA,CB;
double  nenz;
double  nintramol = 1.0;
double	dt;

    if(debug > 1){
		ActionHeader("ReactionPool",enz,action);
    }


    SELECT_ACTION(action){
    case PROCESS:
			mm_substrate_prd = enz->k1;
        	MSGLOOP(enz,msg) {
            		case 0:		/* TYPE = ENZYME. */
							/* msg 0 = n */
   		     			nenz = MSGVALUE(msg,0);
        			break;
				case 1:		/* TYPE = SUBSTRATE. */
							/* msg 0 = S */
							/* dn = -k1.Co.S + (k2+k3).nComplex*/
							/* dnComplex = +k1.Co.S -
							/* (k2+k3).nComplex */
							/* msg 0 = S */
					mm_substrate_prd *= MSGVALUE(msg,0);
				break;
				case 2:		/* TYPE = VOL */
							/* msg 0 = vol */
						enz->vol = MSGVALUE(msg,0);
				break;
				case 3:		/* TYPE = INTRAMOL */
						nintramol *= MSGVALUE(msg,0);
				break;
			}
			if (nintramol > 0)
				nenz /= nintramol;
			dt = Clockrate(enz);
			if (enz->usecomplex) {
				double orig_nenz = nenz;
				/* find the amount of enz not already complexed */
				nenz = (nenz <= enz->nComplex) ?
					0 : nenz - enz->nComplex ;

				enz->sA = enz->k2 * enz->nComplex;
				CA = enz->B = mm_substrate_prd * nenz;
				enz->pA = enz->k3 * enz->nComplex;

				/* eA is not used */
				/* enz->eA = enz->ksum * enz->nComplex; */

				/* Doing the integration for the nComplex */
				CB = enz->ksum;
				enz->nComplex = IntegrateMethod(
					(CB==0.0) ? FEULER_INT :
						enz->object->method,
					enz,enz->nComplex,CA,CB,dt,
					"nComplex");
				if (enz->nComplex < 0)
					enz->nComplex = 0;
				if (enz->nComplex > orig_nenz)
					enz->nComplex = orig_nenz;
				if (enz->vol > 0)
					enz->CoComplex = enz->nComplex / enz->vol;
			} else {	/* When the enz is complexed it becomes
						** inaccessible to other reactions */
				enz->sA = enz->k2 * enz->nComplex;
				CA = enz->B = mm_substrate_prd * nenz;
				enz->pA = enz->k3 * enz->nComplex;
				enz->eA = enz->ksum * enz->nComplex;
				/* Doing the integration for the nComplex */
				CB = enz->ksum;
				enz->nComplex = IntegrateMethod(
					(CB==0.0) ? FEULER_INT :
						enz->object->method,
					enz,enz->nComplex,CA,CB,dt,
					"nComplex");
				if (enz->nComplex < 0)
					enz->nComplex = 0;
				if (enz->vol > 0)
					enz->CoComplex = enz->nComplex / enz->vol;
			}
		break;
    case RESET:
		enz->ksum = enz->k3 + enz->k2;
		enz->nComplex = enz->nComplexInit;
       	MSGLOOP(enz,msg) {
			case 2:		/* TYPE = VOL */
						/* msg 0 = vol */
					enz->vol = MSGVALUE(msg,0);
			break;
		}
		if (enz->vol > 0)
			enz->CoComplexInit = enz->CoComplex =
				enz->nComplex / enz->vol;
        break;
    case SET :
        if (action->argc == 2) {
			char *field = action->argv[0];
			if (strcmp(field,"vol") == 0 ||
				strcmp(field,"nComplex") == 0 ||
				strcmp(field,"nComplexInit") == 0 ||
				strcmp(field,"CoComplex") == 0 ||
				strcmp(field,"CoComplexInit") == 0) {
				double newval = Atof(action->argv[1]);
				if (newval < 0) {
					Error();
					printf("Cannot set field=%s of enz=%s to -ve value\n",
							field,Pathname(enz));
					return(1);
				}
        		if (strcmp(field,"vol") == 0 && newval > 0) {
					enz->vol = newval;
					if (enz->keepconc) { /* keep conc constant */
						enz->nComplex =enz->CoComplex*enz->vol;
						enz->nComplexInit =enz->CoComplexInit*enz->vol;
					} else {
						enz->CoComplex =enz->nComplex/enz->vol;
						enz->CoComplexInit =enz->nComplexInit/enz->vol;
					}
					return(1);
				}
				if (enz->vol > 0) {
        			if (strcmp(field,"nComplex") == 0)
						enz->CoComplex = newval / enz->vol;
        			if (strcmp(field,"nComplexInit") == 0)
						enz->CoComplexInit = newval / enz->vol;

        			if (strcmp(field,"CoComplex") == 0)
						enz->nComplex = newval * enz->vol;
        			if (strcmp(field,"CoComplexInit") == 0)
						enz->nComplexInit = newval * enz->vol;
				}
			}
        	if (strcmp(field,"k2") == 0)
				enz->ksum = enz->k3 + Atof(action->argv[1]);
        	if (strcmp(field,"k3") == 0)
				enz->ksum = enz->k2 + Atof(action->argv[1]);
		}
        return(0); /* do the normal set */
		break;
	case CREATE: /* initializing the vol */
			enz->vol = 1;
		break;
	}
}
