/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- August 1998
 */

/*
 * MacrosSetup.h --- hook the macros files
 */

#ifndef MACROSSETUP_H
#define MACROSSETUP_H

#ifdef _MSC_VER
	using namespace std;
#endif

#include <vector>
#include "CPStr.h"

#define MACROS_FOLDER "Macros"
#define PYTHONLIB_FOLDER "PythonLib"

// a macro is a file + a display name
class CMacroEntry
{
public:
	CMacroEntry() {}
	CMacroEntry(const char *fullname, const char *dispname)
	{
		path = fullname;
		name = dispname;
	}
	CMacroEntry(const CMacroEntry & anentry)
	{
		*this = anentry;
	}

	inline CMacroEntry & operator=(const CMacroEntry & anentry)
	{
		path = anentry.path;
		name = anentry.name;
		return *this;
	}

	inline bool operator<(const CMacroEntry & anentry) const
	{
		return false;
	}

	inline bool operator==(const CMacroEntry & anentry) const
	{
		return path.compare(anentry.path) == 0 && name.compare(anentry.name) == 0;
	}

	CStr path;
	CStr name;
};

// a set of macros + a flag to reload menus
class CMacroSet
{
public:
	CMacroSet()
	{
		invalFlag = true;
	}

	std::vector<CMacroEntry> entries;
	bool invalFlag;

	void Flush(void)
	{
		entries.erase(entries.begin(), entries.end());
		invalFlag = true;
	}

	void Add(const char *fullname, const char *name)
	{
		entries.push_back(CMacroEntry(fullname, name));
	}
};

extern CMacroSet gMacrosAdmin;
extern CMacroSet gMacrosSel;

void MacrosReloadAll(void);
	// reload the available macros
	// TO_OBSOLETE

void MacrosGetLoc(CStr & path);
	// return the macros location

void PythonLibGetLoc(CStr & path);
	// return python library root path

#endif /* MACROSSETUP_H */
