/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * LogDlg.h : the cvs log dialog
 */

#if !defined(AFX_LOGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_LOGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "SmartComboBox.h"

bool CompatGetLog(bool & noRecurs, bool & defBranch, CPStr & date,
	bool & headerOnly, bool & noTags, bool & onlyRCSfile, bool & hasRev,
	CPStr & rev, CPStr & states, bool & hasUser, CPStr & users,
	bool outGraph = false);
	// get the log options...

#ifdef WIN32
class CLogMain : public CPropertyPage
{
	DECLARE_DYNCREATE(CLogMain)

// Construction
public:
	CLogMain();
	~CLogMain();

// Dialog Data
	//{{AFX_DATA(CLogMain)
	enum { IDD = IDD_LOG_MAIN };
	BOOL	m_defbranch;
	BOOL	m_norecurs;
	BOOL	m_notags;
	BOOL	m_nousers;
	BOOL	m_onlyrcs;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CLogMain)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CLogMain)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CLogFilters : public CPropertyPage
{
	DECLARE_DYNCREATE(CLogFilters)

// Construction
public:
	CLogFilters(const char * sLastDate, const char * sLastRev,
		const char * sLastUsers, const char * sLastStates);
	CLogFilters();
	~CLogFilters();

// Dialog Data
	//{{AFX_DATA(CLogFilters)
	enum { IDD = IDD_LOG_FILTERS };
	CSmartComboBox	m_userCombo;
	CSmartComboBox	m_stateCombo;
	CSmartComboBox	m_revCombo;
	CSmartComboBox	m_dateCombo;
	CString	m_date;
	CString	m_rev;
	CString	m_state;
	CString	m_user;
	BOOL	m_hasdate;
	BOOL	m_hasrev;
	BOOL	m_hasstate;
	BOOL	m_hasuser;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CLogFilters)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CLogFilters)
	afx_msg void OnDate();
	afx_msg void OnRev();
	afx_msg void OnState();
	afx_msg void OnUser();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_LOGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
