/*
** Copyright (C) 16 Mar 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "cdlabel.h"
#include "common_gtk.h"
#include "vector_commands.h"
#include "modify_file_set.h"
#include "linebuffer.h"
#include "filepicker.h"
#include "audio.h"
#include "clist_common.h"
#include "mainwindow.h"
#include "contractions.h"
#include "command.h"
#include "globals.h"

char cdlabel_tmp_out[L_tmpnam], cdlabel_tmp_items[L_tmpnam];
char *cdlabelgen_path = NULL;
char *lpr_path = NULL;

static GtkWidget *item_text_col, *print_file_entry, *eps_filename, *use_eps;
static GtkWidget *no_date_radio, *date_radio, *cat_entry, *subcat_entry;
static GtkWidget *tray_filename, *use_tray, *eps_scale, *tray_scale, *date_entry;
static GtkWidget *eps_select_file, *tray_select_file, *no_plaque, *word_wrap;

static void eps_in_use(GtkWidget *w, gpointer d) {
	if ((1 == (int)d) || GTK_TOGGLE_BUTTON(use_eps)->active) {
		gtk_widget_set_sensitive(eps_filename, FALSE);
		gtk_widget_set_sensitive(eps_scale, FALSE);
		gtk_widget_set_sensitive(eps_select_file, FALSE);
	} else {
		gtk_widget_set_sensitive(eps_filename, TRUE);
		gtk_widget_set_sensitive(eps_scale, TRUE);
		gtk_widget_set_sensitive(eps_select_file, TRUE);
	}
}

static void tray_in_use(GtkWidget *w, gpointer d) {
	if ((1 == (int)d) || GTK_TOGGLE_BUTTON(use_tray)->active) {
		gtk_widget_set_sensitive(tray_filename, FALSE);
		gtk_widget_set_sensitive(tray_scale, FALSE);
		gtk_widget_set_sensitive(tray_select_file, FALSE);
	} else {
		gtk_widget_set_sensitive(tray_filename, TRUE);
		gtk_widget_set_sensitive(tray_scale, TRUE);
		gtk_widget_set_sensitive(tray_select_file, TRUE);
	}
}

/* takes the data in either audio_clist or clist (the iso-image) and puts
 * it into item_text_col after emptying it */

static void image_to_item_text(GtkWidget *widget, gpointer a_clist) {
	char *filename, *tmp, *extension;
	int i;

	gtk_text_set_point(GTK_TEXT(item_text_col), 0);
	gtk_text_forward_delete(GTK_TEXT(item_text_col),
			gtk_text_get_length(GTK_TEXT(item_text_col)));

	gtk_text_freeze(GTK_TEXT(item_text_col));

	for (i = 0; i < GTK_CLIST(a_clist)->rows; i++) {
		gtk_clist_get_text(GTK_CLIST(a_clist), i, 0, &tmp);

		if (a_clist == audio_clist) {
			/* strip directory */
			filename = strdup(my_basename(tmp));
			/* strip extension */
			if (NULL != (extension = strrchr(filename, '.'))) {
				if (!(strncasecmp(extension, ".wav",
							strlen(extension) < strlen(".wav") ?
							strlen(extension) : strlen(".wav")))) {
					filename[strlen(filename) - strlen(".wav")] = '\0';
				}
			}
		} else {
			filename = strdup(tmp);
		}

		tmp = string_append(filename, "\n");
		gtk_text_insert(GTK_TEXT(item_text_col), NULL, NULL, NULL, tmp, -1);
		free(tmp);
	}


	gtk_text_thaw(GTK_TEXT(item_text_col));
}

/* takes the data from a dir and puts it into item_text_col after emptying it */

static void dir_to_item_text(GtkWidget *widget, gpointer data) {
	char *path;
	struct stat buf;
	DIR *dir;
	struct dirent *dirp;

	gtk_text_set_point(GTK_TEXT(item_text_col), 0);
	gtk_text_forward_delete(GTK_TEXT(item_text_col),
			gtk_text_get_length(GTK_TEXT(item_text_col)));

	path = gtk_file_selection_get_filename(data);

	if (-1 == (stat(path, &buf))) {
		g_warning("cdlabel.c::dir_to_item_text: could not stat %s", path);
		gtk_widget_destroy(data);
		return;
	}

	gtk_text_freeze(GTK_TEXT(item_text_col));

	if (S_ISDIR(buf.st_mode)) {
		if (NULL == (dir = opendir(path))) {
			g_warning("cdlabel.c::dir_to_item_text: opendir() "
					"failed for %s", path);
			gtk_widget_destroy(data);
			return;
		}
		/* for every filename in path, add it to item_list */
		while (NULL != (dirp = readdir(dir))) {
			if (0 == (strcmp(dirp->d_name, "."))
					|| 0 == strcmp(dirp->d_name, ".."))
				continue;
			gtk_text_insert(GTK_TEXT(item_text_col), NULL,
					NULL, NULL, dirp->d_name, -1);
			gtk_text_insert(GTK_TEXT(item_text_col), NULL,
					NULL, NULL, "\n", -1);
		}
		if (closedir(dir) < 0)
			g_warning("cdlabel.c::dir_to_item_text: close() failed");
	} else /* just one filename, not sure it makes sense, but... */
		gtk_text_insert(GTK_TEXT(item_text_col), NULL, NULL, NULL,
				my_basename(path), -1);

	gtk_text_thaw(GTK_TEXT(item_text_col));

	gtk_widget_destroy(data);
}

static void path_for_to_file(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(print_file_entry),
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(data);
}

static void path_for_eps_file(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(eps_filename),
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(data);
}

static void path_for_tray_file(GtkWidget *widget, gpointer data) {
	gtk_entry_set_text(GTK_ENTRY(tray_filename),
			gtk_file_selection_get_filename(data));
	gtk_widget_destroy(data);
}

/* create a item-file to be fed to cdlabelgen if not already created,
 * write the cd-label info to it and return 0 on success and 1 if failed */

static int cdlabeltext_to_file(void) {
	char *items;
	int fd;

	if ((char)0 == cdlabel_tmp_items[0]) {
		strncpy(cdlabel_tmp_items, "/tmp/gcombustXXXXXX", L_tmpnam);
		if (-1 == (fd = mkstemp(cdlabel_tmp_items))) {
			g_warning("%s::%i: could not create tempfilen for cdlabelgen",
					__FILE__, __LINE__);
			return 1;
		}
	} else {
		if (-1 == (fd = open(cdlabel_tmp_items, O_WRONLY))) {
			g_warning("%s::%i: could not open tempfilen for cdlabelgen",
					__FILE__, __LINE__);
			return 1;
		}
	}
	items = gtk_editable_get_chars(GTK_EDITABLE(item_text_col), 0,
			gtk_text_get_length(GTK_TEXT(item_text_col)));
	items = strdup(items);
	if (0 == strlen(items))
		string_append(items, " ");
	if ('\n' != items[strlen(items)-1])
		items = string_append(items, "\n");

	write(fd, items, strlen(items));

	free(items);

	if (-1 == close(fd))
		g_warning("%s::%i: close() returned -1", __FILE__, __LINE__);
	return 0;
}

/* creates command for cdlabelgen with selected options and executes it */

static int execute_cdlabelgen(GtkWidget *widget, gpointer data) {
	char *cmd, *tmp;

	if (cdlabeltext_to_file())
		return 1;

	if (check_if_exe_ok(cdlabelgen_path))
		return 1;

	cmd = string_append(cdlabelgen_path, NULL);

	cmd = string_append(cmd, " -c ");
	tmp = gtk_entry_get_text(GTK_ENTRY(cat_entry));
	cmd = string_append(cmd, "\'");
	if (0 == strlen(tmp))
		cmd = string_append(cmd, " ");
	else
		cmd = string_append(cmd, tmp);
	cmd = string_append(cmd, "\'");

	cmd = string_append(cmd, " -s ");
	tmp = gtk_entry_get_text(GTK_ENTRY(subcat_entry));
	cmd = string_append(cmd, "\'");
	if (0 == strlen(tmp))
		cmd = string_append(cmd, " ");
	else
		cmd = string_append(cmd, tmp);
	cmd = string_append(cmd, "\'");

	cmd = string_append(cmd, " -f \'");
	cmd = string_append(cmd, cdlabel_tmp_items);
	cmd = string_append(cmd, "\'");

	if (GTK_TOGGLE_BUTTON(no_plaque)->active)
		cmd = string_append(cmd, " -b");
	if (GTK_TOGGLE_BUTTON(word_wrap)->active)
		cmd = string_append(cmd, " -w");

	if (GTK_TOGGLE_BUTTON(use_eps)->active) {
		cmd = string_append(cmd, " -e ");
		cmd = string_append(cmd, "\'");
		cmd = string_append(cmd, gtk_entry_get_text(GTK_ENTRY(eps_filename)));
		cmd = string_append(cmd, "\'");
		cmd = string_append(cmd, " -S ");
		cmd = string_append(cmd, gtk_entry_get_text(GTK_ENTRY(eps_scale)));
	}
	if (GTK_TOGGLE_BUTTON(use_tray)->active) {
		cmd = string_append(cmd, " -E ");
		cmd = string_append(cmd, "\'");
		cmd = string_append(cmd, gtk_entry_get_text(GTK_ENTRY(tray_filename)));
		cmd = string_append(cmd, "\'");
		cmd = string_append(cmd, " -T ");
		cmd = string_append(cmd, gtk_entry_get_text(GTK_ENTRY(tray_scale)));
	}
	if (GTK_TOGGLE_BUTTON(no_date_radio)->active)
		cmd = string_append(cmd, " -D ");
	else if (GTK_TOGGLE_BUTTON(date_radio)->active) {
		if (strcmp("", gtk_entry_get_text(GTK_ENTRY(date_entry)))) {
			cmd = string_append(cmd, " -d ");
			cmd = string_append(cmd, "\'");
			cmd = string_append(cmd,
					gtk_entry_get_text(GTK_ENTRY(date_entry)));
			cmd = string_append(cmd, "\'");
		}
	}
	else
		g_warning("cdlabel.c::execute_cdlabelgen: impossible date error");
	cmd = string_append(cmd, " -o ");
	tmp = gtk_entry_get_text(GTK_ENTRY(print_file_entry));
	if (0 == strlen(tmp)) { /* want gcombust to create a tempfile */
		if ((char)0 == cdlabel_tmp_out[0]) {
			/* don't have a tempfile, create it */
			int fd;
			strncpy(cdlabel_tmp_out, "/tmp/gcombustXXXXXX", L_tmpnam);
			if (-1 == (fd = mkstemp(cdlabel_tmp_out))) {
				g_warning("%s::%i: could not create tempfilen for output",
						__FILE__, __LINE__);
				free(cmd);
				return 1;
			}
			close(fd);
		}
		tmp = cdlabel_tmp_out;
	}
	cmd = string_append(cmd, tmp);
	printf("%s\n", cmd);
	if (0 != system(cmd))
		g_warning("cdlabel.c::execute_cdlabelgen: system(%s) failed", cmd);
	free(cmd);
	return 0;
}

/* regenerate .ps file and print it */

static void do_print_command(char *program) {
	char *cmd, *ps_file;
/*
	if (check_if_exe_ok(program))
		return;
*/
	if (execute_cdlabelgen(NULL, 0))
		return;

	ps_file = gtk_entry_get_text(GTK_ENTRY(print_file_entry));
	if (0 == strlen(ps_file)) { /* if no to-file selected by user */
		if ((char)0 == cdlabel_tmp_out[0]) { /* check if there's a temp-to-file */
			g_warning("cdlabel.c::do_print_command: no ps file generated!");
			return;
		}
		ps_file = cdlabel_tmp_out; /* use the temp file */
	}
	cmd = string_append(program, NULL);
	cmd = string_append(cmd, " \'");
	cmd = string_append(cmd, ps_file);
	cmd = string_append(cmd, "\' &");
	printf("%s\n", cmd);
	if (0 != system(cmd))
		g_warning("cdlabel.c::do_print_command: system(%s) failed", cmd);
	free(cmd);
}

static void execute_gv_preview(GtkWidget *widget, gpointer data) {
	do_print_command("gv");
}

static void execute_cdlabel_print(GtkWidget *widget, gpointer data) {
	if (check_if_exe_ok(lpr_path))
		return;
	do_print_command(lpr_path);
}

void print_cmd_callback(GtkWidget *widget, gpointer data) {
	GtkWidget *notebook2, *category_label, *subcatecory_label, *frame;
	GtkWidget *vbox6, *hbox12, *hbox13, *label, *vbox1;
	GtkWidget *get_image, *get_audio, *get_dir, *vbox7, *hbox8, *hbox14;
	GtkWidget *window3, *hbox11, *get_print_file, *vscrollbar;
	GtkWidget *make_label, *preview, *print, *items_label, *print_label;
	GSList *hbox5_group = NULL;

	/* we have no temp-file when beginning */
	cdlabel_tmp_out[0] = (char)0;
	cdlabel_tmp_items[0] = (char)0;

	window3 = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window3), _("cdlabelgen interface"));

	notebook2 = gtk_notebook_new();
	gtk_widget_show(notebook2);
	gtk_container_add(GTK_CONTAINER(window3), notebook2);

/* cdlabel text - currently you can't fetch label-text data from more than one source,
 * if the user wants more, he has to edit the text with the keyboard */

	vbox6 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox6);
	gtk_container_add(GTK_CONTAINER(notebook2), vbox6);

	hbox12 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox12);
	gtk_box_pack_start(GTK_BOX(vbox6), hbox12, FALSE, FALSE, 0);

	get_image = gtk_button_new_with_label(_("Get data"));
	gtk_widget_show(get_image);
	gtk_box_pack_start(GTK_BOX(hbox12), get_image, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(get_image), "clicked",
			GTK_SIGNAL_FUNC(image_to_item_text), clist);
	gtk_tooltips_set_tip(tooltips, get_image,
			_("Add data selection as label"), NULL);

	get_audio = gtk_button_new_with_label(_("Get audio"));
	gtk_widget_show(get_audio);
	gtk_box_pack_start(GTK_BOX(hbox12), get_audio, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(get_audio), "clicked",
			GTK_SIGNAL_FUNC(image_to_item_text), audio_clist);
	gtk_tooltips_set_tip(tooltips, get_audio,
			_("Add audio selection as label"), NULL);

	get_dir = gtk_button_new_with_label(_("Get dir"));
	gtk_widget_show(get_dir);
	gtk_box_pack_start(GTK_BOX(hbox12), get_dir, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(get_dir), "clicked",
			GTK_SIGNAL_FUNC(choose_file), (gpointer) dir_to_item_text);
	gtk_tooltips_set_tip(tooltips, get_dir,
			_("Add a directory content as label"), NULL);

	hbox14 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox14);
	gtk_box_pack_start(GTK_BOX(vbox6), hbox14, TRUE, TRUE, 3);

	item_text_col = gtk_text_new(NULL, NULL);
	gtk_widget_show(item_text_col);
	gtk_box_pack_start(GTK_BOX(hbox14), item_text_col, TRUE, TRUE, 0);
	gtk_text_set_editable(GTK_TEXT(item_text_col), TRUE);

	vscrollbar = gtk_vscrollbar_new(GTK_TEXT(item_text_col)->vadj);
	gtk_box_pack_start(GTK_BOX(hbox14), vscrollbar, FALSE, FALSE, 0);
	gtk_widget_show(vscrollbar);

	gtk_widget_realize(item_text_col);

/* print */
	frame = make_frame(NULL, 3);
	gtk_container_add(GTK_CONTAINER(notebook2), frame);

	vbox7 = gtk_vbox_new(TRUE, 0);
	gtk_widget_show(vbox7);
	gtk_container_add(GTK_CONTAINER(frame), vbox7);

	/* */
	frame = make_frame(_("Cover label options"), 3);
	gtk_box_pack_start(GTK_BOX(vbox7), frame, FALSE, FALSE, 0);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(frame), vbox1);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	category_label = gtk_label_new(_("Category:     "));
	gtk_widget_show(category_label);
	gtk_box_pack_start(GTK_BOX(hbox8), category_label, FALSE, FALSE, 0);

	cat_entry = gtk_entry_new();
	gtk_widget_show(cat_entry);
	gtk_box_pack_start(GTK_BOX(hbox8), cat_entry, TRUE, TRUE, 0);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	subcatecory_label = gtk_label_new(_("Subcategory:"));
	gtk_widget_show(subcatecory_label);
	gtk_box_pack_start(GTK_BOX(hbox8), subcatecory_label, FALSE, FALSE, 0);

	subcat_entry = gtk_entry_new();
	gtk_widget_show(subcat_entry);
	gtk_box_pack_start(GTK_BOX(hbox8), subcat_entry, TRUE, TRUE, 0);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	no_date_radio = gtk_radio_button_new_with_label(hbox5_group, _("No date"));
	hbox5_group = gtk_radio_button_group(GTK_RADIO_BUTTON(no_date_radio));
	gtk_widget_show(no_date_radio);
	gtk_box_pack_start(GTK_BOX(hbox8), no_date_radio, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, no_date_radio,
			_("Don't print date on cover"), NULL);

	date_radio = gtk_radio_button_new_with_label(hbox5_group, _("Date"));
	hbox5_group = gtk_radio_button_group(GTK_RADIO_BUTTON(date_radio));
	gtk_widget_show(date_radio);
	gtk_box_pack_start(GTK_BOX(hbox8), date_radio, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, date_radio,
			_("Print date on cover"), NULL);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(date_radio), TRUE);

	date_entry = gtk_entry_new();
	gtk_widget_show(date_entry);
	gtk_tooltips_set_tip(tooltips, date_entry,
			_("If nothing is entered, today's date will be used"), NULL);
	gtk_box_pack_start(GTK_BOX(hbox8), date_entry, FALSE, TRUE, 0);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	no_plaque = gtk_check_button_new_with_label(_("No plaque"));
	gtk_widget_show(no_plaque);
	gtk_box_pack_start(GTK_BOX(hbox8), no_plaque, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, no_plaque, _(
				"Suppresses printing of the Plaque (the category/subcategory banner)"
				"on the traycard, "
				"thus allowing you to fit even more items on the traycard."
				"(needs cdlabelgen 1.5 or newer)"), NULL);

	word_wrap = gtk_check_button_new_with_label(_("Enable word wrapping"));
	gtk_widget_show(word_wrap);
	gtk_box_pack_start(GTK_BOX(hbox8), word_wrap, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, word_wrap, _(
				"Enables word wrapping of the items that print on the traycard."
				"(needs cdlabelgen 1.5 or newer)"), NULL);

	/* */
	frame = make_frame(_("EPS-file options"), 3);
	gtk_box_pack_start(GTK_BOX(vbox7), frame, FALSE, FALSE, 0);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(frame), vbox1);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	use_eps = gtk_check_button_new_with_label(_("Cover eps file"));
	gtk_widget_show(use_eps);
	gtk_box_pack_start(GTK_BOX(hbox8), use_eps, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, use_eps,
			_("Add an EPS (Encapsulated PostScript) file to the cover"),
			NULL);
	gtk_signal_connect(GTK_OBJECT(use_eps), "button_release_event",
			GTK_SIGNAL_FUNC(eps_in_use), 0);

	eps_scale = gtk_entry_new();
	gtk_widget_show(eps_scale);
	gtk_box_pack_end(GTK_BOX(hbox8), eps_scale, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, eps_scale,
			_("The ratio by which you "
			"want to scale the epsfile that appears on the cover"), NULL);
	gtk_entry_set_text(GTK_ENTRY(eps_scale), "1");

	label = gtk_label_new(_("Scale:"));
	gtk_widget_show(label);
	gtk_box_pack_end(GTK_BOX(hbox8), label, FALSE, FALSE, 0);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	eps_select_file = gtk_button_new_with_label(_("Pick file:"));
	gtk_widget_show(eps_select_file);
	gtk_box_pack_start(GTK_BOX(hbox8), eps_select_file, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(eps_select_file), "clicked",
			GTK_SIGNAL_FUNC(choose_file), (gpointer) path_for_eps_file);
	gtk_tooltips_set_tip(tooltips, eps_select_file,
			_("Select cover EPS file"), NULL);

	eps_filename = gtk_entry_new();
	gtk_widget_show(eps_filename);
	gtk_box_pack_start(GTK_BOX(hbox8), eps_filename, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, eps_filename,
			_("Path to cover EPS file"), NULL);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	use_tray = gtk_check_button_new_with_label(_("Tray EPS file"));
	gtk_widget_show(use_tray);
	gtk_box_pack_start(GTK_BOX(hbox8), use_tray, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, use_tray,
			_("Add an EPS (Encapsulated PostScript) file to the traycard"),
			NULL);
	gtk_signal_connect(GTK_OBJECT(use_tray), "button_release_event",
			GTK_SIGNAL_FUNC(tray_in_use), 0);

	tray_scale = gtk_entry_new();
	gtk_widget_show(tray_scale);
	gtk_box_pack_end(GTK_BOX(hbox8), tray_scale, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, tray_scale,
			_("The ratio by which you want "
			"to scale the epsfile that appears on the traycard"), NULL);
	gtk_entry_set_text(GTK_ENTRY(tray_scale), "1");

	label = gtk_label_new(_("Scale:"));
	gtk_widget_show(label);
	gtk_box_pack_end(GTK_BOX(hbox8), label, FALSE, FALSE, 0);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox8, FALSE, FALSE, 0);

	tray_select_file = gtk_button_new_with_label(_("Pick file:"));
	gtk_widget_show(tray_select_file);
	gtk_box_pack_start(GTK_BOX(hbox8), tray_select_file, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(tray_select_file), "clicked",
			GTK_SIGNAL_FUNC(choose_file), (gpointer) path_for_tray_file);
	gtk_tooltips_set_tip(tooltips, tray_select_file,
			_("Select traycard EPS file"), NULL);

	tray_filename = gtk_entry_new();
	gtk_widget_show(tray_filename);
	gtk_box_pack_start(GTK_BOX(hbox8), tray_filename, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, tray_filename,
			_("Path to traycard EPS file"), NULL);
	/* */
	frame = make_frame(_("Make cover"), 3);
        gtk_box_pack_start(GTK_BOX(vbox7), frame, FALSE, FALSE, 0);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
        gtk_container_add(GTK_CONTAINER(frame), vbox1);

	hbox11 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox11);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox11, FALSE, FALSE, 0);
	
	get_print_file = gtk_button_new_with_label(_("Pick file:"));
	gtk_widget_show(get_print_file);
	gtk_box_pack_start(GTK_BOX(hbox11), get_print_file, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(get_print_file), "clicked",
			GTK_SIGNAL_FUNC(choose_file), (gpointer) path_for_to_file);
	gtk_tooltips_set_tip(tooltips, get_print_file,
			_("Select file to print to, "
			"if it exists it will be overwritten."), NULL);

	print_file_entry = gtk_entry_new();
	gtk_widget_show(print_file_entry);
	gtk_box_pack_start(GTK_BOX(hbox11), print_file_entry, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, print_file_entry,
			_("File to print to, if no "
			"file is selected, gcombust will create a temporary file and "
			"delete it afterwards"), NULL);

	hbox13 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox13);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox13, FALSE, FALSE, 0);

	make_label = gtk_button_new_with_label(_("Save to file"));
	gtk_widget_show(make_label);
	gtk_box_pack_start(GTK_BOX(hbox13), make_label, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(make_label), "clicked",
			GTK_SIGNAL_FUNC(execute_cdlabelgen), NULL);
	gtk_tooltips_set_tip(tooltips, make_label,
			_("Save cover as a PS file"), NULL);

	preview = gtk_button_new_with_label(_("Preview"));
	gtk_widget_show(preview);
	gtk_box_pack_start(GTK_BOX(hbox13), preview, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(preview), "clicked",
			GTK_SIGNAL_FUNC(execute_gv_preview), NULL);
	gtk_tooltips_set_tip(tooltips, preview,
			_("Preview the cover with gv"), NULL);

	print = gtk_button_new_with_label(_("Print"));
	gtk_widget_show(print);
	gtk_box_pack_start(GTK_BOX(hbox13), print, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(print), "clicked",
			GTK_SIGNAL_FUNC(execute_cdlabel_print), NULL);
	gtk_tooltips_set_tip(tooltips, print,
			_("Print cover with lpr"), NULL);

/* notebook labels */

	items_label = gtk_label_new(_("Items"));
	gtk_widget_show(items_label);
	set_notebook_tab(notebook2, 0, items_label);

	print_label = gtk_label_new(_("Print"));
	gtk_widget_show(print_label);
	set_notebook_tab(notebook2, 1, print_label);

	gtk_widget_show(window3);

	tray_in_use(NULL, (gpointer)1);
	eps_in_use(NULL, (gpointer)1);
}

