/******************************************
 *
 * $GAMGI/src/mesa/gamgi_mesa_axes.c
 *
 * Copyright (C) 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_mesa.h"
#include "gamgi_math.h"
#include "gamgi_phys.h"

#include "gamgi_math_vector.h"
#include "gamgi_math_cell.h"

static void static_sphere (double width)
{
glPushMatrix ();
glScalef (width, width, width);
glCallList (GAMGI_MESA_SPHERE);
glPopMatrix ();
}

static void static_axis (double *v, double width)
{
double small[3], big[3];
double length, angle;
double height;

length = gamgi_math_vector_length (v);
angle = acos (v[2] / length) * GAMGI_MATH_RAD_DEG;
height = length - 2 * width;
gamgi_math_vector_scale (v, small, width / length);
gamgi_math_vector_scale (v, big, height / length);

/*************************************
 * draw axis: sphere-cylinder-sphere *
 *************************************/

glPushMatrix ();
glTranslatef (small[0], small[1], small[2]);
static_sphere (width);

glPushMatrix ();
if (length - fabs (v[2]) > GAMGI_MATH_TOLERANCE_LENGTH)
  glRotatef (angle, -v[1], v[0], 0.0);
else
  glRotatef (angle, 1.0, 0.0, 0.0);
glScalef (width, width, height);
glCallList (GAMGI_MESA_CYLINDER_1);
glPopMatrix ();

glTranslatef (big[0], big[1], big[2]);
static_sphere (width);
glPopMatrix ();
}

void gamgi_mesa_axes (double *origin, double *a, double *b, double *c)
{
glTranslatef (origin[0], origin[1], origin[2]);

/*********************************
 * draw axes along a,b,c vectors *
 *********************************/

static_axis (a, GAMGI_MESA_AXES_WIDTH);
static_axis (b, GAMGI_MESA_AXES_WIDTH);
static_axis (c, GAMGI_MESA_AXES_WIDTH);
}

void gamgi_mesa_axes_color (double *origin, double *a, double *b, double *c)
{
glTranslatef (origin[0], origin[1], origin[2]);

/*********************************
 * draw axes along a,b,c vectors *
 *********************************/

glColor3f (GAMGI_MESA_AXIS_1_R, GAMGI_MESA_AXIS_1_G, GAMGI_MESA_AXIS_1_B);
static_axis (a, GAMGI_MESA_AXES_WIDTH);

glColor3f (GAMGI_MESA_AXIS_2_R, GAMGI_MESA_AXIS_2_G, GAMGI_MESA_AXIS_2_B);
static_axis (b, GAMGI_MESA_AXES_WIDTH);

glColor3f (GAMGI_MESA_AXIS_3_R, GAMGI_MESA_AXIS_3_G, GAMGI_MESA_AXIS_3_B);
static_axis (c, GAMGI_MESA_AXES_WIDTH);
}

void gamgi_mesa_axes_cell (gamgi_cell *cell, gamgi_bool color)
{
double *v1, *v2, *v3;
double offset[3];

gamgi_math_cell_offset (cell, offset);

if (cell->axes_vectors == GAMGI_PHYS_CONVENTIONAL)
  {
  v1 = cell->a1;
  v2 = cell->a2;
  v3 = cell->a3;
  }
else
  {
  v1 = cell->p1;
  v2 = cell->p2;
  v3 = cell->p3;
  }

if (color == TRUE)
  gamgi_mesa_axes_color (offset, v1, v2, v3);
else
  gamgi_mesa_axes (offset, v1, v2, v3);
}

void gamgi_mesa_axes_layer (gamgi_layer *layer, gamgi_bool color)
{
double origin[3], v1[3], v2[3], v3[3];

gamgi_math_vector_zero (origin);

gamgi_math_vector_absolute (v1, 1.0, 0.0, 0.0);
gamgi_math_vector_absolute (v2, 0.0, 1.0, 0.0);
gamgi_math_vector_absolute (v3, 0.0, 0.0, 1.0);

if (color == TRUE)
  gamgi_mesa_axes_color (origin, v1, v2, v3);
else
  gamgi_mesa_axes (origin, v1, v2, v3);
}
