/******************************************
 *
 * $GAMGI/src/gtk/gamgi_gtk_gamgi_exit.c
 *
 * Copyright (C) 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_global.h"

#include "gamgi_gtk_dialog.h"
#include "gamgi_gtk_window_remove.h"
#include "gamgi_mesa_lists.h"
#include "gamgi_global_selection.h"

void gamgi_gtk_gamgi_exit_dialogs (void)
{
/*************************
 * remove global dialogs *
 *************************/

if (gamgi->question != NULL)
gamgi_gtk_dialog_remove (gamgi->question, &gamgi->question);
if (gamgi->message != NULL)
  gamgi_gtk_dialog_remove (gamgi->message, &gamgi->message);
}

void gamgi_gtk_gamgi_exit_ok (GtkWidget *widget, void *data)
{ 
gamgi_window *window;

/****************************
 * 1) remove mesa lists     *
 * 2) remove global dialogs *
 * 3) remove global timers  *
 *  (to show the time)      *
 ****************************/

gamgi_mesa_lists_remove ();

gamgi_gtk_gamgi_exit_dialogs ();

g_source_remove (gamgi->timer_time);

/*********************************
 * remove object selection lists *
 *********************************/

gamgi_global_selection_remove_all ();

/************************************************************
 * remove dialogs, timers, Gtk windows: dialogs may address *
 * other windows, so it is important to remove them first!  *
 ************************************************************/

for (window = gamgi->window_start; window != NULL; window = window->next)
  gamgi_gtk_window_remove_dialogs (window);

for (window = gamgi->window_start; window != NULL; window = window->next)
  {
  gamgi_gtk_window_remove_timers (window);
  gamgi_gtk_window_remove_window (window);
  }

/***********************************************
 * quit the gtk main loop: execution continues *
 * immediately after gtk_main (), on main ().  *
 ***********************************************/

gtk_main_quit ();
}

void gamgi_gtk_gamgi_exit (GtkWidget *widget, void *data)
{
gamgi_gtk_dialog_question_create ("Exit", "Exit the program?", 
gamgi_gtk_gamgi_exit_ok, data);
}
