#!/usr/bin/env python

import pygtk
pygtk.require('2.0')
import gtk
import galago
import sys

def setup_info():
    # Setup our services
    aim_service = galago.create_service("aim")
    jabber_service = galago.create_service("jabber")

    # Create our local person
    me = galago.get_me(galago.LOCAL)

    # Set up our person's AIM account
    account = aim_service.create_account(me, "GalagoAIMUser")
    presence = account.create_presence()

    presence.set_idle(True, 60 * 5)

    status = galago.Status(galago.STATUS_AWAY, "away", "Away", True)
    status.set_attr_string("message", "I'm eating dinner.")
    presence.add_status(status)

    # Add contacts to our AIM account
    person   = galago.create_person("gonkulator-1")
    contact  = aim_service.create_account(person, "lottabs2")
    presence = contact.create_presence()
    presence.set_idle(True, 60 * 20)
    account.add_contact(contact)
    contact.set_avatar(galago.Image(""));
    try:
        f = open("avatar.png", "r")
        avatar = galago.Avatar(contact, f.read())
        f.close()
    except:
        print "Unable to open avatar.png for reading"
        raise

    # Set up our person's Jabber account
    account  = jabber_service.create_account(me, "jabberuser@galago.sf.net")
    presence = account.create_presence()

    status = galago.Status(galago.STATUS_AVAILABLE, "available",
                           "Available", True)
    presence.add_status(status)

    # Add contacts to our Jabber account
    person   = galago.create_person("cae-1")
    contact  = jabber_service.create_account(person, "caedan@jabber.org")
    presence = contact.create_presence()

    status = galago.Status(galago.STATUS_AVAILABLE, "available",
                           "Available", True)
    presence.add_status(status)

    account.add_contact(contact)

    contact  = jabber_service.create_account(person, "caelum@chipx86.com")
    presence = contact.create_presence()

    status = galago.Status(galago.STATUS_OFFLINE, "offline", "Offline", True)
    presence.add_status(status)
    account.add_contact(contact)


if not galago.init("test-feed", galago.INIT_FEED):
    print "Unable to initialize Galago and connect to the server"
    sys.exit(1)

setup_info()

gtk.main()
