/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007-2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#ifndef backup_and_restore_H
#define backup_and_restore_H

extern struct w *widgets;

void backup_button_clicked(struct w *widgets);
void cancel_process_clicked(struct w *widgets);

void run_process_command(struct w *widgets, gchar *cmd);

gboolean read_process_output(GIOChannel *channel, GIOCondition condition, struct w *widgets);
gboolean read_process_error(GIOChannel *channel, GIOCondition condition, struct w *widgets);

void show_progress(gchar *line, struct w *widgets);

#endif
