/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "commented.h"

extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;


void populate_host_treeview(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    gchar *utf8=NULL;
    GtkTreePath *path;
    gboolean edit=0;
    int i=0, set_cursorpath=0;
    long conf_size=0;
    char *tmp, *line;
    char *hostname;
    char *hwaddr;
    char *ipaddr;

    gtk_list_store_clear(widgets->host_store);

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
       return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line     = allocate(conf_size+1);
    tmp      = allocate(MAX_CONF_LINE);
    hostname = allocate(MAX_CONF_LINE);
    hwaddr   = allocate(MAX_CONF_LINE);
    ipaddr   = allocate(MAX_CONF_LINE);

    if( conf_size > 1 )    
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) || strlen(line) < 3 || strlen(line) > MAX_CONF_LINE )
	  continue;

	/* Locate "host " as the first thing written on a line. */
	for(i=0; i<strlen(line); i++)
	{
	    /* Break at the first non-space found. */
	    if( line[i]!=' ' && line[i]!='\t' )
	      break; 
	}
	snprintf(tmp, MAX_CONF_LINE, "%s", &line[i]);
	for(i=0; i<strlen(tmp); i++)
	{
	    /* Break at the first non-space found. */
	    if( tmp[i]==' ' || tmp[i]=='\t' || tmp[i]=='\n' )
	      break; 
	}
	tmp[i+1]='\0';

	if( ! strcmp(tmp, "host ") == 0 )
	  continue;
	
	sscanf(line, "%*s %s", hostname);	    
	while(fgets(line, conf_size, fp)!=NULL)
	{
	    if( strstr(line, "{") )
	      break;

	    if( strstr(line, "hardware ethernet ") && ! strstr(line, "#") )
	    {
	        sscanf(line, "%*s %*s %s", hwaddr);
	        continue;
	    }

	    if( strstr(line, "fixed-address ") && ! strstr(line, "#") )
	    {
	        sscanf(line, "%*s %s", ipaddr);

	        gtk_list_store_append(GTK_LIST_STORE(widgets->host_store), &iter);

		if( strstr(hostname, "{") )
		  hostname[strlen(hostname)-1]='\0';
		utf8 = g_locale_to_utf8(hostname, strlen(hostname), NULL, NULL, NULL);
		gtk_list_store_set(GTK_LIST_STORE(widgets->host_store), &iter, 0, utf8, -1);
		    
		utf8 = g_locale_to_utf8(ipaddr, strlen(ipaddr)-1, NULL, NULL, NULL);
		gtk_list_store_set(GTK_LIST_STORE(widgets->host_store), &iter, 1, utf8, -1);
		    
		utf8 = g_locale_to_utf8(hwaddr, strlen(hwaddr)-1, NULL, NULL, NULL);
		gtk_list_store_set(GTK_LIST_STORE(widgets->host_store), &iter, 2, utf8, -1);
		set_cursorpath = 1;
		break;
	    }
	}
    }
    fclose(fp);
    free(line);
    free(tmp);
    free(hostname);
    free(ipaddr);
    free(hwaddr);

    if( utf8!=NULL )
      g_free(utf8);

    if( ! set_cursorpath )
      return;
    
    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->host_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
