/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "populate_host_treeview.h"
#include "select_first_host.h"
#include "populate_host_settings.h"
#include "reread_conf.h"

extern char DHCPD_CONF_BUF[1024];



void add_host(struct w *widgets)
{
    FILE *fp;
    long conf_size;
    char *line;
    int host_found = 0;
    gchar *host_conf, *host_line, *info;
    G_CONST_RETURN gchar *hostname, *ipaddr, *hwaddr;
    
    hostname = gtk_entry_get_text(GTK_ENTRY(widgets->host_add_hostname_entry));
    ipaddr   = gtk_entry_get_text(GTK_ENTRY(widgets->host_add_ipaddr_entry));
    hwaddr   = gtk_entry_get_text(GTK_ENTRY(widgets->host_add_hwaddr_entry));

    if( strlen(hostname) < 1 )
    {
        info = g_strdup_printf(_("The hostname is too short, the host was not added.\n"));
        show_info(info);
        g_free(info);
	return;
    }

    if( strlen(ipaddr) < 7 )
    {
        info = g_strdup_printf(_("The IP-address is too short, the host was not added.\n"));
        show_info(info);
        g_free(info);
	return;
    }

    if( strlen(hwaddr) < 11 )
    {
        info = g_strdup_printf(_("The hardware address is too short, the host was not added.\n"));
        show_info(info);
        g_free(info);
	return;
    }
    

    /* If the hostname already exists, dont add the host */
    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Could not read dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    host_line = g_strdup_printf("host %s {\n", hostname);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( !strcmp(line, host_line) && ! strstr(line, "#") )
	{
	    host_found = 1;
	    break;
	}
    }
    fclose(fp);
    free(line);
    g_free(host_line);

    if( host_found )
    {
	info = g_strdup_printf(_("The host already exists, the host was not added.\n"));
	show_info(info);
	g_free(info);
	return;	
    }


    /* Add the host */
    if((fp=fopen(DHCPD_CONF_BUF, "a"))==NULL)
    {
        printf("Could not write dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
        return;
    }
    host_conf = g_strdup_printf("host %s {\n    hardware ethernet %s;\n    fixed-address %s;\n}\n", 
								                          hostname, 
											  hwaddr, 
									                  ipaddr);
    fputs(host_conf, fp);
    fclose(fp);
    g_free(host_conf);

    populate_host_treeview(widgets);

    select_first_host(widgets);

    populate_host_settings(widgets);

    reread_conf();
}
